"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiQuickSelect = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _accessibility = require("../../../accessibility");
var _button = require("../../../button");
var _flex = require("../../../flex");
var _form = require("../../../form");
var _tool_tip = require("../../../tool_tip");
var _time_options = require("../time_options");
var _quick_select_utils = require("./quick_select_utils");
var _quick_select_panel = require("./quick_select_panel");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1bcvmj9-render",
  styles: "> div{position:relative;overflow:visible;};label:render;"
} : {
  name: "1bcvmj9-render",
  styles: "> div{position:relative;overflow:visible;};label:render;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "12n8nux-render",
  styles: "position:absolute;right:0;bottom:100%;transform:translateY(-33%);label:render;"
} : {
  name: "12n8nux-render",
  styles: "position:absolute;right:0;bottom:100%;transform:translateY(-33%);label:render;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var EuiQuickSelect = exports.EuiQuickSelect = /*#__PURE__*/function (_Component) {
  function EuiQuickSelect(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiQuickSelect);
    _this = _callSuper(this, EuiQuickSelect, [props]);
    (0, _defineProperty2.default)(_this, "generateId", (0, _services.htmlIdGenerator)());
    (0, _defineProperty2.default)(_this, "timeSelectionId", _this.generateId());
    (0, _defineProperty2.default)(_this, "legendId", _this.generateId());
    (0, _defineProperty2.default)(_this, "onTimeTenseChange", function (event) {
      _this.setState({
        timeTense: event.target.value
      });
    });
    (0, _defineProperty2.default)(_this, "onTimeValueChange", function (event) {
      var sanitizedValue = parseInt(event.target.value, 10);
      _this.setState({
        timeValue: isNaN(sanitizedValue) ? 0 : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(_this, "onTimeUnitsChange", function (event) {
      _this.setState({
        timeUnits: event.target.value
      });
    });
    (0, _defineProperty2.default)(_this, "handleKeyDown", function (_ref) {
      var key = _ref.key;
      if (key === 'Enter') {
        _this.applyQuickSelect();
      }
    });
    (0, _defineProperty2.default)(_this, "applyQuickSelect", function () {
      var _this$state = _this.state,
        timeTense = _this$state.timeTense,
        timeValue = _this$state.timeValue,
        timeUnits = _this$state.timeUnits;
      if (timeTense === _time_options.NEXT) {
        _this.props.applyTime({
          start: 'now',
          end: "now+".concat(timeValue).concat(timeUnits),
          quickSelect: _objectSpread({}, _this.state)
        });
        return;
      }
      _this.props.applyTime({
        start: "now-".concat(timeValue).concat(timeUnits),
        end: 'now',
        quickSelect: _objectSpread({}, _this.state)
      });
    });
    (0, _defineProperty2.default)(_this, "getBounds", function () {
      var startMoment = _datemath.default.parse(_this.props.start);
      var endMoment = _datemath.default.parse(_this.props.end, {
        roundUp: true
      });
      return {
        min: startMoment && startMoment.isValid() ? startMoment : (0, _moment.default)().subtract(15, 'minute'),
        max: endMoment && endMoment.isValid() ? endMoment : (0, _moment.default)()
      };
    });
    (0, _defineProperty2.default)(_this, "stepForward", function () {
      var _this$getBounds = _this.getBounds(),
        min = _this$getBounds.min,
        max = _this$getBounds.max;
      var diff = max.diff(min);
      _this.props.applyTime({
        start: (0, _moment.default)(max).add(1, 'ms').toISOString(),
        end: (0, _moment.default)(max).add(diff + 1, 'ms').toISOString(),
        keepPopoverOpen: true
      });
    });
    (0, _defineProperty2.default)(_this, "stepBackward", function () {
      var _this$getBounds2 = _this.getBounds(),
        min = _this$getBounds2.min,
        max = _this$getBounds2.max;
      var diff = max.diff(min);
      _this.props.applyTime({
        start: (0, _moment.default)(min).subtract(diff + 1, 'ms').toISOString(),
        end: (0, _moment.default)(min).subtract(1, 'ms').toISOString(),
        keepPopoverOpen: true
      });
    });
    var _parseTimeParts = (0, _quick_select_utils.parseTimeParts)(props.start, props.end),
      timeTenseDefault = _parseTimeParts.timeTense,
      timeUnitsDefault = _parseTimeParts.timeUnits,
      timeValueDefault = _parseTimeParts.timeValue;
    _this.state = {
      timeTense: props.prevQuickSelect && props.prevQuickSelect.timeTense ? props.prevQuickSelect.timeTense : timeTenseDefault,
      timeValue: props.prevQuickSelect && props.prevQuickSelect.timeValue ? props.prevQuickSelect.timeValue : timeValueDefault,
      timeUnits: props.prevQuickSelect && props.prevQuickSelect.timeUnits ? props.prevQuickSelect.timeUnits : timeUnitsDefault
    };
    return _this;
  }
  (0, _inherits2.default)(EuiQuickSelect, _Component);
  return (0, _createClass2.default)(EuiQuickSelect, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$state2 = this.state,
        timeTense = _this$state2.timeTense,
        timeValue = _this$state2.timeValue,
        timeUnits = _this$state2.timeUnits;
      var _this$props$timeOptio = this.props.timeOptions,
        timeTenseOptions = _this$props$timeOptio.timeTenseOptions,
        timeUnitsOptions = _this$props$timeOptio.timeUnitsOptions;
      var matchedTimeUnit = timeUnitsOptions.find(function (_ref2) {
        var value = _ref2.value;
        return value === timeUnits;
      });
      var timeUnit = matchedTimeUnit ? matchedTimeUnit.text : '';
      return (0, _react2.jsx)(_quick_select_panel.EuiQuickSelectPanel, {
        component: "fieldset",
        title: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiQuickSelect.quickSelectTitle",
          default: "Quick select"
        }),
        titleId: this.legendId,
        "aria-describedby": this.timeSelectionId,
        css: _ref3
      }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
        css: _ref4,
        alignItems: "center",
        gutterSize: "s",
        responsive: false
      }, (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiQuickSelect.previousLabel",
        default: "Previous time window"
      }, function (previousLabel) {
        return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
          content: previousLabel
        }, (0, _react2.jsx)(_button.EuiButtonIcon, {
          "aria-label": previousLabel,
          iconType: "arrowLeft",
          onClick: _this2.stepBackward
        }));
      })), (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiQuickSelect.nextLabel",
        default: "Next time window"
      }, function (nextLabel) {
        return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
          content: nextLabel
        }, (0, _react2.jsx)(_button.EuiButtonIcon, {
          "aria-label": nextLabel,
          iconType: "arrowRight",
          onClick: _this2.stepForward
        }));
      }))), (0, _react2.jsx)(_flex.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false
      }, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiQuickSelect.tenseLabel",
        default: "Time tense"
      }, function (tenseLabel) {
        return (0, _react2.jsx)(_form.EuiSelect, {
          compressed: true,
          onKeyDown: _this2.handleKeyDown,
          "aria-label": tenseLabel,
          "aria-describedby": "".concat(_this2.timeSelectionId, " ").concat(_this2.legendId),
          value: timeTense,
          options: timeTenseOptions,
          onChange: _this2.onTimeTenseChange
        });
      })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiQuickSelect.valueLabel",
        default: "Time value"
      }, function (valueLabel) {
        return (0, _react2.jsx)(_form.EuiFieldNumber, {
          compressed: true,
          onKeyDown: _this2.handleKeyDown,
          "aria-describedby": "".concat(_this2.timeSelectionId, " ").concat(_this2.legendId),
          "aria-label": valueLabel,
          value: timeValue,
          onChange: _this2.onTimeValueChange
        });
      })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiQuickSelect.unitLabel",
        default: "Time unit"
      }, function (unitLabel) {
        return (0, _react2.jsx)(_form.EuiSelect, {
          compressed: true,
          onKeyDown: _this2.handleKeyDown,
          "aria-label": unitLabel,
          "aria-describedby": "".concat(_this2.timeSelectionId, " ").concat(_this2.legendId),
          value: timeUnits,
          options: timeUnitsOptions,
          onChange: _this2.onTimeUnitsChange
        });
      })), (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false
      }, (0, _react2.jsx)(_button.EuiButton, {
        "aria-describedby": "".concat(this.timeSelectionId, " ").concat(this.legendId),
        "data-test-subj": "superDatePickerQuickSelectApplyButton",
        minWidth: 0 // Allow the button to shrink
        ,
        size: "s",
        onClick: this.applyQuickSelect,
        disabled: timeValue <= 0
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiQuickSelect.applyButton",
        default: "Apply"
      })))), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
        id: this.timeSelectionId
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiQuickSelect.fullDescription",
        default: "Currently set to {timeTense} {timeValue} {timeUnit}.",
        values: {
          timeTense: timeTense,
          timeValue: timeValue,
          timeUnit: timeUnit
        }
      }))));
    }
  }]);
}(_react.Component);
EuiQuickSelect.propTypes = {
  applyTime: _propTypes.default.func.isRequired,
  start: _propTypes.default.string.isRequired,
  end: _propTypes.default.string.isRequired,
  prevQuickSelect: _propTypes.default.shape({
    timeTense: _propTypes.default.string.isRequired,
    timeValue: _propTypes.default.number.isRequired,
    timeUnits: _propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired
  }),
  timeOptions: _propTypes.default.shape({
    timeTenseOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    timeUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    relativeOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
      text: _propTypes.default.string.isRequired,
      value: _propTypes.default.oneOfType([_propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, _propTypes.default.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: _propTypes.default.any.isRequired,
    refreshUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    commonDurationRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
      end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
      label: _propTypes.default.string,
      start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};