"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuperDatePickerInternal = exports.EuiSuperDatePicker = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _services = require("../../../services");
var _predicate = require("../../../services/predicate");
var _context = require("../../context");
var _date_picker_range = require("../date_picker_range");
var _form = require("../../form");
var _time_options = require("./time_options");
var _pretty_duration = require("./pretty_duration");
var _async_interval = require("./async_interval");
var _super_update_button = require("./super_update_button");
var _quick_select_popover = require("./quick_select_popover/quick_select_popover");
var _date_popover_button = require("./date_popover/date_popover_button");
var _auto_refresh = require("../auto_refresh/auto_refresh");
var _super_date_picker = require("./super_date_picker.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isDisabled"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // eslint-disable-line import/named
function isRangeInvalid(start, end, minDate, maxDate) {
  if (start === 'now' && end === 'now') {
    return true;
  }
  var startMoment = _datemath.default.parse(start);
  var endMoment = _datemath.default.parse(end, {
    roundUp: true
  });
  var isInvalid = !startMoment || !endMoment || !startMoment.isValid() || !endMoment.isValid() || !(0, _moment.default)(startMoment).isValid() || !(0, _moment.default)(endMoment).isValid() || startMoment.isAfter(endMoment) || endMoment.isBefore(startMoment) || minDate != null && startMoment.isBefore(minDate) || maxDate != null && endMoment.isAfter(maxDate);
  return isInvalid;
}
var EuiSuperDatePickerInternal = exports.EuiSuperDatePickerInternal = /*#__PURE__*/function (_Component) {
  function EuiSuperDatePickerInternal() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiSuperDatePickerInternal);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSuperDatePickerInternal, [].concat(args));
    (0, _defineProperty2.default)(_this, "asyncInterval", void 0);
    (0, _defineProperty2.default)(_this, "state", {
      prevProps: {
        start: _this.props.start,
        end: _this.props.end
      },
      start: _this.props.start,
      end: _this.props.end,
      isInvalid: isRangeInvalid(_this.props.start, _this.props.end, _this.props.minDate, _this.props.maxDate),
      hasChanged: false,
      showPrettyDuration: (0, _pretty_duration.showPrettyDuration)(_this.props.start, _this.props.end, _this.props.commonlyUsedRanges),
      isStartDatePopoverOpen: false,
      isEndDatePopoverOpen: false
    });
    (0, _defineProperty2.default)(_this, "setTime", function (_ref) {
      var end = _ref.end,
        start = _ref.start;
      var isInvalid = isRangeInvalid(start, end, _this.props.minDate, _this.props.maxDate);
      _this.setState({
        start: start,
        end: end,
        isInvalid: isInvalid,
        hasChanged: !(_this.state.prevProps.start === start && _this.state.prevProps.end === end)
      });
      if (!_this.props.showUpdateButton) {
        _this.props.onTimeChange({
          start: start,
          end: end,
          isQuickSelection: false,
          isInvalid: isInvalid
        });
      }
    });
    (0, _defineProperty2.default)(_this, "componentDidMount", function () {
      if (!_this.props.isPaused) {
        _this.startInterval(_this.props.refreshInterval);
      }
    });
    (0, _defineProperty2.default)(_this, "componentDidUpdate", function () {
      _this.stopInterval();
      if (!_this.props.isPaused) {
        _this.startInterval(_this.props.refreshInterval);
      }
    });
    (0, _defineProperty2.default)(_this, "componentWillUnmount", function () {
      _this.stopInterval();
    });
    (0, _defineProperty2.default)(_this, "setStart", function (start) {
      _this.setTime({
        start: start,
        end: _this.state.end
      });
    });
    (0, _defineProperty2.default)(_this, "setEnd", function (end) {
      _this.setTime({
        start: _this.state.start,
        end: end
      });
    });
    (0, _defineProperty2.default)(_this, "applyTime", function () {
      _this.props.onTimeChange({
        start: _this.state.start,
        end: _this.state.end,
        isQuickSelection: false,
        isInvalid: false
      });
    });
    (0, _defineProperty2.default)(_this, "applyQuickTime", function (_ref2) {
      var start = _ref2.start,
        end = _ref2.end;
      _this.setState({
        showPrettyDuration: (0, _pretty_duration.showPrettyDuration)(start, end, _this.props.commonlyUsedRanges)
      });
      _this.props.onTimeChange({
        start: start,
        end: end,
        isQuickSelection: true,
        isInvalid: false
      });
    });
    (0, _defineProperty2.default)(_this, "hidePrettyDuration", function () {
      _this.setState({
        showPrettyDuration: false,
        isStartDatePopoverOpen: true
      });
    });
    (0, _defineProperty2.default)(_this, "onStartDatePopoverToggle", function () {
      _this.setState(function (prevState) {
        return {
          isStartDatePopoverOpen: !prevState.isStartDatePopoverOpen
        };
      });
    });
    (0, _defineProperty2.default)(_this, "onStartDatePopoverClose", function () {
      _this.setState({
        isStartDatePopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(_this, "onEndDatePopoverToggle", function () {
      _this.setState(function (prevState) {
        return {
          isEndDatePopoverOpen: !prevState.isEndDatePopoverOpen
        };
      });
    });
    (0, _defineProperty2.default)(_this, "onEndDatePopoverClose", function () {
      _this.setState({
        isEndDatePopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(_this, "onRefreshChange", function (_ref3) {
      var refreshInterval = _ref3.refreshInterval,
        intervalUnits = _ref3.intervalUnits,
        isPaused = _ref3.isPaused;
      _this.stopInterval();
      if (!isPaused) {
        _this.startInterval(refreshInterval);
      }
      if (_this.props.onRefreshChange) {
        _this.props.onRefreshChange({
          refreshInterval: refreshInterval,
          isPaused: isPaused,
          intervalUnits: intervalUnits
        });
      }
    });
    (0, _defineProperty2.default)(_this, "stopInterval", function () {
      if (_this.asyncInterval) {
        _this.asyncInterval.stop();
      }
    });
    (0, _defineProperty2.default)(_this, "startInterval", function (refreshInterval) {
      var onRefresh = _this.props.onRefresh;
      if (onRefresh) {
        var handler = function handler() {
          var _this$props = _this.props,
            start = _this$props.start,
            end = _this$props.end;
          onRefresh({
            start: start,
            end: end,
            refreshInterval: refreshInterval
          });
        };
        _this.asyncInterval = new _async_interval.AsyncInterval(handler, refreshInterval);
      }
    });
    (0, _defineProperty2.default)(_this, "renderQuickSelect", function () {
      var _this$props2 = _this.props,
        start = _this$props2.start,
        end = _this$props2.end,
        customQuickSelectPanels = _this$props2.customQuickSelectPanels,
        customQuickSelectRender = _this$props2.customQuickSelectRender,
        commonlyUsedRanges = _this$props2.commonlyUsedRanges,
        timeOptions = _this$props2.timeOptions,
        dateFormat = _this$props2.dateFormat,
        onRefreshChange = _this$props2.onRefreshChange,
        recentlyUsedRanges = _this$props2.recentlyUsedRanges,
        refreshInterval = _this$props2.refreshInterval,
        refreshMinInterval = _this$props2.refreshMinInterval,
        refreshIntervalUnits = _this$props2.refreshIntervalUnits,
        isPaused = _this$props2.isPaused,
        isDisabled = _this$props2.isDisabled;
      return (0, _react2.jsx)(_quick_select_popover.EuiQuickSelectPopover, {
        applyRefreshInterval: onRefreshChange ? _this.onRefreshChange : undefined,
        applyTime: _this.applyQuickTime,
        commonlyUsedRanges: commonlyUsedRanges,
        customQuickSelectPanels: customQuickSelectPanels,
        customQuickSelectRender: customQuickSelectRender,
        dateFormat: dateFormat,
        end: end,
        isDisabled: !!isDisabled,
        isPaused: isPaused,
        recentlyUsedRanges: recentlyUsedRanges,
        refreshInterval: refreshInterval,
        refreshMinInterval: refreshMinInterval,
        intervalUnits: refreshIntervalUnits,
        start: start,
        timeOptions: timeOptions
      });
    });
    (0, _defineProperty2.default)(_this, "renderDatePickerRange", function () {
      var _this$state = _this.state,
        end = _this$state.end,
        hasChanged = _this$state.hasChanged,
        isEndDatePopoverOpen = _this$state.isEndDatePopoverOpen,
        isInvalid = _this$state.isInvalid,
        isStartDatePopoverOpen = _this$state.isStartDatePopoverOpen,
        showPrettyDuration = _this$state.showPrettyDuration,
        start = _this$state.start;
      var _this$props3 = _this.props,
        isQuickSelectOnly = _this$props3.isQuickSelectOnly,
        showUpdateButton = _this$props3.showUpdateButton,
        commonlyUsedRanges = _this$props3.commonlyUsedRanges,
        canRoundRelativeUnits = _this$props3.canRoundRelativeUnits,
        timeOptions = _this$props3.timeOptions,
        dateFormat = _this$props3.dateFormat,
        refreshInterval = _this$props3.refreshInterval,
        refreshMinInterval = _this$props3.refreshMinInterval,
        refreshIntervalUnits = _this$props3.refreshIntervalUnits,
        isPaused = _this$props3.isPaused,
        isDisabled = _this$props3.isDisabled,
        isLoading = _this$props3.isLoading,
        locale = _this$props3.locale,
        timeFormat = _this$props3.timeFormat,
        utcOffset = _this$props3.utcOffset,
        minDate = _this$props3.minDate,
        maxDate = _this$props3.maxDate,
        compressed = _this$props3.compressed,
        onFocus = _this$props3.onFocus,
        styles = _this$props3.memoizedStyles;
      var autoRefreshAppend = !isPaused ? (0, _react2.jsx)(_auto_refresh.EuiAutoRefreshButton, {
        refreshInterval: refreshInterval,
        minInterval: refreshMinInterval,
        intervalUnits: refreshIntervalUnits,
        isDisabled: !!isDisabled,
        isPaused: isPaused,
        onRefreshChange: _this.onRefreshChange,
        shortHand: true
      }) : undefined;
      var formControlLayoutProps = {
        compressed: compressed,
        isInvalid: isInvalid,
        isLoading: isLoading && !showUpdateButton,
        isDisabled: !!isDisabled,
        prepend: _this.renderQuickSelect(),
        append: autoRefreshAppend,
        fullWidth: true,
        css: [styles.states.euiSuperDatePicker__formControlLayout, isDisabled ? styles.states.disabled : isInvalid ? styles.states.invalid : hasChanged ? styles.states.needsUpdating : styles.states.default]
      };
      if (isQuickSelectOnly) {
        return (0, _react2.jsx)(_form.EuiFormControlLayout, (0, _extends2.default)({
          iconsPosition: "static"
        }, formControlLayoutProps));
      }
      var isDisabledDisplay = (0, _predicate.isObject)(isDisabled) && (isDisabled === null || isDisabled === void 0 ? void 0 : isDisabled.display);
      if (isDisabledDisplay || showPrettyDuration && !isStartDatePopoverOpen && !isEndDatePopoverOpen) {
        return (0, _react2.jsx)(_form.EuiFormControlLayout, formControlLayoutProps, (0, _react2.jsx)("button", {
          type: "button",
          css: styles.euiSuperDatePicker__prettyFormat,
          className: (0, _classnames.default)('euiSuperDatePicker__prettyFormat', {
            'euiSuperDatePicker__prettyFormat--disabled': isDisabled
          }),
          "data-test-subj": "superDatePickerShowDatesButton",
          disabled: !!isDisabled,
          onClick: _this.hidePrettyDuration,
          onFocus: onFocus
        }, isDisabledDisplay ? isDisabled.display : (0, _react2.jsx)(_pretty_duration.PrettyDuration, {
          timeFrom: start,
          timeTo: end,
          quickRanges: commonlyUsedRanges,
          dateFormat: dateFormat
        })));
      }
      var rangeCssStyles = [styles.euiSuperDatePicker__range, formControlLayoutProps.css];

      // EuiFormControlLayout wants `isDisabled`, EuiDatePickerRange wants `disabled` :T
      var _ = formControlLayoutProps.isDisabled,
        _rangeProps = (0, _objectWithoutProperties2.default)(formControlLayoutProps, _excluded);
      var rangeProps = _objectSpread(_objectSpread({}, _rangeProps), {}, {
        disabled: formControlLayoutProps.isDisabled
      });
      return (0, _react2.jsx)(_context.EuiI18nConsumer, null, function (_ref4) {
        var contextLocale = _ref4.locale;
        return (0, _react2.jsx)(_date_picker_range.EuiDatePickerRange, (0, _extends2.default)({}, rangeProps, {
          css: rangeCssStyles,
          isCustom: true,
          iconType: false,
          startDateControl: (0, _react2.jsx)(_date_popover_button.EuiDatePopoverButton, {
            css: styles.euiSuperDatePicker__rangeInput,
            className: "euiSuperDatePicker__startPopoverButton",
            compressed: compressed,
            position: "start",
            needsUpdating: hasChanged,
            isInvalid: isInvalid,
            isDisabled: !!isDisabled,
            onChange: _this.setStart,
            value: start,
            dateFormat: dateFormat,
            utcOffset: utcOffset,
            timeFormat: timeFormat,
            locale: locale || contextLocale,
            minDate: minDate,
            maxDate: maxDate,
            canRoundRelativeUnits: canRoundRelativeUnits,
            isOpen: _this.state.isStartDatePopoverOpen,
            onPopoverToggle: _this.onStartDatePopoverToggle,
            onPopoverClose: _this.onStartDatePopoverClose,
            timeOptions: timeOptions,
            buttonProps: {
              onFocus: onFocus
            }
          }),
          endDateControl: (0, _react2.jsx)(_date_popover_button.EuiDatePopoverButton, {
            css: styles.euiSuperDatePicker__rangeInput,
            position: "end",
            compressed: compressed,
            needsUpdating: hasChanged,
            isInvalid: isInvalid,
            isDisabled: !!isDisabled,
            onChange: _this.setEnd,
            value: end,
            dateFormat: dateFormat,
            utcOffset: utcOffset,
            timeFormat: timeFormat,
            locale: locale || contextLocale,
            minDate: minDate,
            maxDate: maxDate,
            canRoundRelativeUnits: canRoundRelativeUnits,
            roundUp: true,
            isOpen: _this.state.isEndDatePopoverOpen,
            onPopoverToggle: _this.onEndDatePopoverToggle,
            onPopoverClose: _this.onEndDatePopoverClose,
            timeOptions: timeOptions,
            buttonProps: {
              onFocus: onFocus
            }
          })
        }));
      });
    });
    (0, _defineProperty2.default)(_this, "handleClickUpdateButton", function () {
      if (!_this.state.hasChanged && _this.props.onRefresh) {
        var _this$props4 = _this.props,
          start = _this$props4.start,
          end = _this$props4.end,
          refreshInterval = _this$props4.refreshInterval;
        _this.props.onRefresh({
          start: start,
          end: end,
          refreshInterval: refreshInterval
        });
      } else {
        _this.applyTime();
      }
    });
    (0, _defineProperty2.default)(_this, "renderUpdateButton", function () {
      var _this$props5 = _this.props,
        isLoading = _this$props5.isLoading,
        isDisabled = _this$props5.isDisabled,
        updateButtonProps = _this$props5.updateButtonProps,
        showUpdateButton = _this$props5.showUpdateButton,
        compressed = _this$props5.compressed;
      if (!showUpdateButton) return null;
      return (0, _react2.jsx)(_super_update_button.EuiSuperUpdateButton, (0, _extends2.default)({
        needsUpdate: _this.state.hasChanged,
        showTooltip: !_this.state.isStartDatePopoverOpen && !_this.state.isEndDatePopoverOpen,
        isLoading: isLoading,
        isDisabled: !!isDisabled || _this.state.isInvalid,
        onClick: _this.handleClickUpdateButton,
        "data-test-subj": "superDatePickerApplyTimeButton",
        size: compressed ? 's' : 'm',
        iconOnly: showUpdateButton === 'iconOnly'
      }, updateButtonProps));
    });
    return _this;
  }
  (0, _inherits2.default)(EuiSuperDatePickerInternal, _Component);
  return (0, _createClass2.default)(EuiSuperDatePickerInternal, [{
    key: "render",
    value: function render() {
      var _this$props6 = this.props,
        isAutoRefreshOnly = _this$props6.isAutoRefreshOnly,
        isDisabled = _this$props6.isDisabled,
        isPaused = _this$props6.isPaused,
        onRefreshChange = _this$props6.onRefreshChange,
        refreshInterval = _this$props6.refreshInterval,
        refreshMinInterval = _this$props6.refreshMinInterval,
        refreshIntervalUnits = _this$props6.refreshIntervalUnits,
        showUpdateButton = _this$props6.showUpdateButton,
        dataTestSubj = _this$props6['data-test-subj'],
        _width = _this$props6.width,
        isQuickSelectOnly = _this$props6.isQuickSelectOnly,
        compressed = _this$props6.compressed,
        className = _this$props6.className,
        styles = _this$props6.memoizedStyles;
      var _this$state2 = this.state,
        hasChanged = _this$state2.hasChanged,
        isInvalid = _this$state2.isInvalid;
      var classes = (0, _classnames.default)('euiSuperDatePicker', className, {
        'euiSuperDatePicker--needsUpdating': hasChanged && !isDisabled && !isInvalid
      });

      // Force reduction in width if showing quick select only
      var width = isQuickSelectOnly ? 'auto' : _width !== null && _width !== void 0 ? _width : 'restricted';
      var cssStyles = [styles.euiSuperDatePicker, styles.widths[width], !showUpdateButton && styles.noUpdateButton[width], isAutoRefreshOnly && styles.isAutoRefreshOnly[width], isQuickSelectOnly && styles.isQuickSelectOnly];
      return (0, _react2.jsx)("div", {
        css: cssStyles,
        className: classes,
        "data-test-subj": dataTestSubj
      }, isAutoRefreshOnly && onRefreshChange ? (0, _react2.jsx)(_auto_refresh.EuiAutoRefresh, {
        isPaused: isPaused,
        refreshInterval: refreshInterval,
        minInterval: refreshMinInterval,
        intervalUnits: refreshIntervalUnits,
        onRefreshChange: this.onRefreshChange,
        fullWidth: width === 'full',
        compressed: compressed,
        isDisabled: !!isDisabled,
        className: className
      }) : (0, _react2.jsx)(_react.default.Fragment, null, this.renderDatePickerRange(), this.renderUpdateButton()));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.start !== prevState.prevProps.start || nextProps.end !== prevState.prevProps.end) {
        return {
          prevProps: {
            start: nextProps.start,
            end: nextProps.end
          },
          start: nextProps.start,
          end: nextProps.end,
          isInvalid: isRangeInvalid(nextProps.start, nextProps.end, nextProps.minDate, nextProps.maxDate),
          hasChanged: false,
          showPrettyDuration: (0, _pretty_duration.showPrettyDuration)(nextProps.start, nextProps.end, nextProps.commonlyUsedRanges)
        };
      }
      return null;
    }
  }]);
}(_react.Component); // Because EuiSuperDatePicker is a class component and not a functional component,
// we have to use a render prop here in order for us to pass i18n'd strings/objects/etc
// to all underlying usages of our timeOptions constants. If someday we convert
// EuiSuperDatePicker to an FC, we can likely get rid of this wrapper.
(0, _defineProperty2.default)(EuiSuperDatePickerInternal, "defaultProps", {
  dateFormat: 'MMM D, YYYY @ HH:mm:ss.SSS',
  end: 'now',
  isAutoRefreshOnly: false,
  isDisabled: false,
  isPaused: true,
  recentlyUsedRanges: [],
  refreshInterval: 1000,
  showUpdateButton: true,
  canRoundRelativeUnits: true,
  start: 'now-15m',
  timeFormat: 'HH:mm',
  width: 'restricted'
});
EuiSuperDatePickerInternal.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  // The below options are marked as required because they have default fallbacks
  commonlyUsedRanges: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired), _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired]),
  customQuickSelectPanels: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string.isRequired,
    content: _propTypes.default.element.isRequired
  }).isRequired),
  /**
     * An optional render prop function that allows customizing the display of the Quick Select menu.
     * This function passes all default quick select panels within an object, allowing you to
     * re-order panels, omit certain panels entirely, or pass in your own fully custom content.
     */
  customQuickSelectRender: _propTypes.default.func,
  /**
     * Specifies the formatted used when displaying dates and/or datetimes
     * @default 'MMM D, YYYY @ HH:mm:ss.SSS'
     */
  dateFormat: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string.isRequired]),
  /**
     * Set isAutoRefreshOnly to true to limit the component to only display auto refresh content.
     */
  isAutoRefreshOnly: _propTypes.default.bool,
  /**
     * Accepts either a true/false boolean or an object configuration.
     *
     * The configuration will render the component as disabled, and allow you to
     * customize the displayed disabled text.
     */
  isDisabled: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    display: _propTypes.default.node.isRequired
  }).isRequired]),
  isLoading: _propTypes.default.bool,
  /**
     * @default true
     */
  isPaused: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.bool.isRequired]),
  /**
     * Sets the overall width by adding sensible min and max widths.
     * - `auto`: fits width to internal content / time string.
     * - `restricted`: static width that fits the longest possible time string.
     * - `full`: expands to 100% of the container.
     * @default 'restricted'
     */
  width: _propTypes.default.oneOf(["restricted", "full", "auto"]),
  /**
     * Reduces overall height to compressed form size
     */
  compressed: _propTypes.default.bool,
  /**
     * Used to localize e.g. month names, passed to `moment`
     */
  locale: _propTypes.default.any,
  /**
     * Triggered whenever the EuiSuperDatePicker's dates are focused
     */
  onFocus: _propTypes.default.any,
  /**
     * Callback for when the refresh interval is fired.
     * EuiSuperDatePicker will only manage a refresh interval timer when onRefresh callback is supplied
     * If a promise is returned, the next refresh interval will not start until the promise has resolved.
     * If the promise rejects the refresh interval will stop and the error thrown
     */
  onRefresh: _propTypes.default.func,
  /**
     * Callback for when the refresh interval changes.
     * Supply onRefreshChange to show refresh interval inputs in quick select popover
     */
  onRefreshChange: _propTypes.default.func,
  /**
     * Callback for when the time changes.
     */
  onTimeChange: _propTypes.default.func.isRequired,
  recentlyUsedRanges: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired), _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired]),
  refreshInterval: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.number.isRequired]),
  refreshMinInterval: _propTypes.default.number,
  /**
     * By default, refresh interval units will be rounded up to next largest unit of time
     * (for example, 90 seconds will become 2m).
     *
     * If you do not want this behavior, you will need to store the user-set `intervalUnits`
     * (passed by `onRefreshChange`) and manually control it via this prop.
     */
  refreshIntervalUnits: _propTypes.default.any,
  start: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]), _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired]),
  end: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]), _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired]),
  /**
     * Defines min. date accepted as a selection (in moment format)
     */
  minDate: _propTypes.default.any,
  /**
     * Defines max. date accepted as a selection (in moment format)
     */
  maxDate: _propTypes.default.any,
  /**
     * Specifies the formatted used when displaying times
     * @default 'HH:mm'
     */
  timeFormat: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string.isRequired]),
  utcOffset: _propTypes.default.number,
  /**
     * Set showUpdateButton to false to immediately invoke onTimeChange for all start and end changes.
     * @default true
     */
  showUpdateButton: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["iconOnly"])]),
  /**
     * Hides the actual input reducing to just the quick select button.
     */
  isQuickSelectOnly: _propTypes.default.bool,
  /**
     * Props passed to the update button #EuiSuperUpdateButtonProps
     */
  updateButtonProps: _propTypes.default.shape({
    /**
       * Overrides the default button label with a custom React node.
       *
       * When defined, you're responsible for updating the custom label
       * when the data needs updating (the `needsUpdate` prop)
       * or is loading (the `isLoading` prop).
       */
    children: _propTypes.default.node,
    /**
       * Show the "Click to apply" tooltip
       */
    showTooltip: _propTypes.default.bool,
    /**
       * Passes props to `EuiToolTip`
       */
    toolTipProps: _propTypes.default.any,
    /**
       * Returns an IconButton instead
       */
    iconOnly: _propTypes.default.bool,
    /**
       * Forces state to be `iconOnly` when within provided breakpoints.
       * Remove completely with `false` or provide your own list of breakpoints.
       */
    responsive: _propTypes.default.oneOfType([_propTypes.default.oneOf([false]), _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired])
  }),
  /**
     * By default, relative units will be rounded up to next largest unit of time
     * (for example, 90 minutes will become ~ 2 hours).
     *
     * If you do not want this behavior and instead wish to keep the exact units
     * input by the user, set this flag to `false`.
     */
  canRoundRelativeUnits: _propTypes.default.bool,
  memoizedStyles: _propTypes.default.any.isRequired,
  timeOptions: _propTypes.default.shape({
    timeTenseOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    timeUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    relativeOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
      text: _propTypes.default.string.isRequired,
      value: _propTypes.default.oneOfType([_propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, _propTypes.default.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: _propTypes.default.any.isRequired,
    refreshUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    commonDurationRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
      end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
      label: _propTypes.default.string,
      start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};
var EuiSuperDatePicker = exports.EuiSuperDatePicker = function EuiSuperDatePicker(props) {
  var styles = (0, _services.useEuiMemoizedStyles)(_super_date_picker.euiSuperDatePickerStyles);
  return (0, _react2.jsx)(_time_options.RenderI18nTimeOptions, null, function (timeOptions) {
    return (0, _react2.jsx)(EuiSuperDatePickerInternal, (0, _extends2.default)({}, props, {
      timeOptions: timeOptions,
      commonlyUsedRanges: props.commonlyUsedRanges || timeOptions.commonDurationRanges,
      memoizedStyles: styles
    }));
  });
};
EuiSuperDatePicker.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  commonlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired),
  customQuickSelectPanels: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string.isRequired,
    content: _propTypes.default.element.isRequired
  }).isRequired),
  /**
     * An optional render prop function that allows customizing the display of the Quick Select menu.
     * This function passes all default quick select panels within an object, allowing you to
     * re-order panels, omit certain panels entirely, or pass in your own fully custom content.
     */
  customQuickSelectRender: _propTypes.default.func,
  /**
     * Specifies the formatted used when displaying dates and/or datetimes
     * @default 'MMM D, YYYY @ HH:mm:ss.SSS'
     */
  dateFormat: _propTypes.default.string,
  /**
     * Set isAutoRefreshOnly to true to limit the component to only display auto refresh content.
     */
  isAutoRefreshOnly: _propTypes.default.bool,
  /**
     * Accepts either a true/false boolean or an object configuration.
     *
     * The configuration will render the component as disabled, and allow you to
     * customize the displayed disabled text.
     */
  isDisabled: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    display: _propTypes.default.node.isRequired
  }).isRequired]),
  isLoading: _propTypes.default.bool,
  /**
     * @default true
     */
  isPaused: _propTypes.default.bool,
  /**
     * Sets the overall width by adding sensible min and max widths.
     * - `auto`: fits width to internal content / time string.
     * - `restricted`: static width that fits the longest possible time string.
     * - `full`: expands to 100% of the container.
     * @default 'restricted'
     */
  width: _propTypes.default.oneOf(["restricted", "full", "auto"]),
  /**
     * Reduces overall height to compressed form size
     */
  compressed: _propTypes.default.bool,
  /**
     * Used to localize e.g. month names, passed to `moment`
     */
  locale: _propTypes.default.any,
  /**
     * Triggered whenever the EuiSuperDatePicker's dates are focused
     */
  onFocus: _propTypes.default.any,
  /**
     * Callback for when the refresh interval is fired.
     * EuiSuperDatePicker will only manage a refresh interval timer when onRefresh callback is supplied
     * If a promise is returned, the next refresh interval will not start until the promise has resolved.
     * If the promise rejects the refresh interval will stop and the error thrown
     */
  onRefresh: _propTypes.default.func,
  /**
     * Callback for when the refresh interval changes.
     * Supply onRefreshChange to show refresh interval inputs in quick select popover
     */
  onRefreshChange: _propTypes.default.func,
  /**
     * Callback for when the time changes.
     */
  onTimeChange: _propTypes.default.func.isRequired,
  recentlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired),
  /**
     * Minimum refresh interval in milliseconds
     * @default 0
     */
  refreshInterval: _propTypes.default.number,
  refreshMinInterval: _propTypes.default.number,
  /**
     * By default, refresh interval units will be rounded up to next largest unit of time
     * (for example, 90 seconds will become 2m).
     *
     * If you do not want this behavior, you will need to store the user-set `intervalUnits`
     * (passed by `onRefreshChange`) and manually control it via this prop.
     */
  refreshIntervalUnits: _propTypes.default.any,
  /**
     * @default 'now'
     */
  start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]),
  end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]),
  /**
     * Defines min. date accepted as a selection (in moment format)
     */
  minDate: _propTypes.default.any,
  /**
     * Defines max. date accepted as a selection (in moment format)
     */
  maxDate: _propTypes.default.any,
  /**
     * Specifies the formatted used when displaying times
     * @default 'HH:mm'
     */
  timeFormat: _propTypes.default.string,
  utcOffset: _propTypes.default.number,
  /**
     * Set showUpdateButton to false to immediately invoke onTimeChange for all start and end changes.
     * @default true
     */
  showUpdateButton: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["iconOnly"])]),
  /**
     * Hides the actual input reducing to just the quick select button.
     */
  isQuickSelectOnly: _propTypes.default.bool,
  /**
     * Props passed to the update button #EuiSuperUpdateButtonProps
     */
  updateButtonProps: _propTypes.default.shape({
    children: _propTypes.default.node,
    showTooltip: _propTypes.default.bool,
    toolTipProps: _propTypes.default.any,
    iconOnly: _propTypes.default.bool,
    responsive: _propTypes.default.oneOfType([_propTypes.default.oneOf([false]), _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired])
  }),
  /**
     * By default, relative units will be rounded up to next largest unit of time
     * (for example, 90 minutes will become ~ 2 hours).
     *
     * If you do not want this behavior and instead wish to keep the exact units
     * input by the user, set this flag to `false`.
     */
  canRoundRelativeUnits: _propTypes.default.bool
};