"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuperUpdateButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = require("../../button");
var _i18n = require("../../i18n");
var _tool_tip = require("../../tool_tip");
var _responsive2 = require("../../responsive");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "needsUpdate", "isLoading", "isDisabled", "onClick", "toolTipProps", "showTooltip", "iconOnly", "responsive", "textProps", "fill"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiSuperUpdateButton = exports.EuiSuperUpdateButton = /*#__PURE__*/function (_Component) {
  function EuiSuperUpdateButton() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiSuperUpdateButton);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSuperUpdateButton, [].concat(args));
    (0, _defineProperty2.default)(_this, "_isMounted", false);
    (0, _defineProperty2.default)(_this, "tooltipTimeout", void 0);
    (0, _defineProperty2.default)(_this, "tooltip", null);
    (0, _defineProperty2.default)(_this, "setTootipRef", function (node) {
      _this.tooltip = node;
    });
    (0, _defineProperty2.default)(_this, "showTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }
      _this.tooltip.showToolTip();
    });
    (0, _defineProperty2.default)(_this, "hideTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }
      _this.tooltip.hideToolTip();
    });
    return _this;
  }
  (0, _inherits2.default)(EuiSuperUpdateButton, _Component);
  return (0, _createClass2.default)(EuiSuperUpdateButton, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this2 = this;
      if (this.props.showTooltip && this.props.needsUpdate && !this.props.isDisabled && !this.props.isLoading) {
        this.showTooltip();
        this.tooltipTimeout = setTimeout(function () {
          _this2.hideTooltip();
        }, 2000);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        needsUpdate = _this$props.needsUpdate,
        isLoading = _this$props.isLoading,
        isDisabled = _this$props.isDisabled,
        onClick = _this$props.onClick,
        toolTipProps = _this$props.toolTipProps,
        showTooltip = _this$props.showTooltip,
        iconOnly = _this$props.iconOnly,
        _responsive = _this$props.responsive,
        restTextProps = _this$props.textProps,
        fill = _this$props.fill,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      // Force responsive for "all" if `iconOnly = true`
      var responsive = iconOnly ? 'all' : _responsive;
      var classes = (0, _classnames.default)('euiSuperUpdateButton', className);
      var sharedButtonProps = {
        color: needsUpdate || isLoading ? 'success' : 'primary',
        iconType: needsUpdate || isLoading ? 'kqlFunction' : 'refresh',
        isDisabled: isDisabled,
        onClick: onClick,
        isLoading: isLoading
      };
      var buttonContent = this.renderButtonContent();
      return (0, _react2.jsx)(_tool_tip.EuiToolTip, (0, _extends2.default)({
        ref: this.setTootipRef,
        content: this.renderTooltipContent(),
        position: "bottom"
      }, toolTipProps), (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_responsive2.EuiShowFor, {
        sizes: responsive || 'none'
      }, (0, _react2.jsx)(_button.EuiButton, (0, _extends2.default)({
        className: classes,
        minWidth: false
      }, sharedButtonProps, {
        fill: fill,
        textProps: _objectSpread(_objectSpread({}, restTextProps), {}, {
          className: (0, _classnames.default)('euiScreenReaderOnly', restTextProps && restTextProps.className)
        })
      }, rest), buttonContent)), (0, _react2.jsx)(_responsive2.EuiHideFor, {
        sizes: responsive || 'none'
      }, (0, _react2.jsx)(_button.EuiButton, (0, _extends2.default)({
        className: classes,
        minWidth: 118
      }, sharedButtonProps, {
        fill: fill,
        textProps: restTextProps
      }, rest), buttonContent))));
    }
  }, {
    key: "renderButtonContent",
    value: function renderButtonContent() {
      var _this$props2 = this.props,
        children = _this$props2.children,
        isLoading = _this$props2.isLoading,
        needsUpdate = _this$props2.needsUpdate;
      if (children) {
        return children;
      }
      if (isLoading) {
        return (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSuperUpdateButton.updatingButtonLabel",
          default: "Updating"
        });
      }
      if (needsUpdate) {
        return (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSuperUpdateButton.updateButtonLabel",
          default: "Update"
        });
      }
      return (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiSuperUpdateButton.refreshButtonLabel",
        default: "Refresh"
      });
    }
  }, {
    key: "renderTooltipContent",
    value: function renderTooltipContent() {
      if (this.props.isDisabled) {
        return (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSuperUpdateButton.cannotUpdateTooltip",
          default: "Cannot update"
        });
      }
      if (this.props.needsUpdate && !this.props.isLoading) {
        return (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSuperUpdateButton.clickToApplyTooltip",
          default: "Click to apply"
        });
      }
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiSuperUpdateButton, "defaultProps", {
  needsUpdate: false,
  isLoading: false,
  isDisabled: false,
  showTooltip: false,
  responsive: ['xs', 's'],
  fill: true
});
EuiSuperUpdateButton.propTypes = {
  isDisabled: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  needsUpdate: _propTypes.default.bool,
  onClick: _propTypes.default.func.isRequired,
  /**
     * Overrides the default button label with a custom React node.
     *
     * When defined, you're responsible for updating the custom label
     * when the data needs updating (the `needsUpdate` prop)
     * or is loading (the `isLoading` prop).
     */
  children: _propTypes.default.node,
  /**
     * Show the "Click to apply" tooltip
     */
  showTooltip: _propTypes.default.bool,
  /**
     * Passes props to `EuiToolTip`
     */
  toolTipProps: _propTypes.default.any,
  /**
     * Returns an IconButton instead
     */
  iconOnly: _propTypes.default.bool,
  /**
     * Forces state to be `iconOnly` when within provided breakpoints.
     * Remove completely with `false` or provide your own list of breakpoints.
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.oneOf([false]), _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired])
};