"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDragDropReorder = exports.euiDragDropMove = exports.euiDragDropCopy = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDragDropReorder = exports.euiDragDropReorder = function euiDragDropReorder(list, startIndex, endIndex) {
  var result = (0, _toConsumableArray2.default)(list);
  var _result$splice = result.splice(startIndex, 1),
    _result$splice2 = (0, _slicedToArray2.default)(_result$splice, 1),
    removed = _result$splice2[0];
  result.splice(endIndex, 0, removed);
  return result;
};
var euiDragDropMove = exports.euiDragDropMove = function euiDragDropMove(sourceList, destinationList, dropResultSource, dropResultDestination) {
  var sourceClone = (0, _toConsumableArray2.default)(sourceList);
  var destClone = (0, _toConsumableArray2.default)(destinationList);
  var _sourceClone$splice = sourceClone.splice(dropResultSource.index, 1),
    _sourceClone$splice2 = (0, _slicedToArray2.default)(_sourceClone$splice, 1),
    removed = _sourceClone$splice2[0];
  destClone.splice(dropResultDestination.index, 0, removed);
  return (0, _defineProperty2.default)((0, _defineProperty2.default)({}, dropResultSource.droppableId, sourceClone), dropResultDestination.droppableId, destClone);
};
var euiDragDropCopy = exports.euiDragDropCopy = function euiDragDropCopy(sourceList, destinationList, dropResultSource, dropResultDestination, idModification) {
  var sourceClone = (0, _toConsumableArray2.default)(sourceList);
  var destClone = (0, _toConsumableArray2.default)(destinationList);
  destClone.splice(dropResultDestination.index, 0, _objectSpread(_objectSpread({}, sourceList[dropResultSource.index]), {}, (0, _defineProperty2.default)({}, idModification.property, idModification.modifier())));
  return (0, _defineProperty2.default)((0, _defineProperty2.default)({}, dropResultSource.droppableId, sourceClone), dropResultDestination.droppableId, destClone);
};