"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiErrorMessage = exports.EuiErrorBoundary = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _title = require("../title");
var _code = require("../code");
var _i18n = require("../i18n");
var _error_boundary = require("./error_boundary.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children"],
  _excluded2 = ["errorMessage", "className", "data-test-subj"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiErrorBoundary = exports.EuiErrorBoundary = /*#__PURE__*/function (_Component) {
  function EuiErrorBoundary(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiErrorBoundary);
    _this = _callSuper(this, EuiErrorBoundary, [props]);
    var errorState = {
      hasError: false,
      errorMessage: undefined
    };
    _this.state = errorState;
    return _this;
  }
  (0, _inherits2.default)(EuiErrorBoundary, _Component);
  return (0, _createClass2.default)(EuiErrorBoundary, [{
    key: "componentDidCatch",
    value: function componentDidCatch(error) {
      var _this$props$onError, _this$props;
      // Display fallback UI
      // Only Chrome includes the `message` property as part of `stack`.
      // For consistency, rebuild the full error text from the Error subparts.
      var message = error.message,
        stack = error.stack;
      var idx = (stack === null || stack === void 0 ? void 0 : stack.indexOf(message)) || -1;
      var stackStr = idx > -1 ? stack === null || stack === void 0 ? void 0 : stack.substring(idx + message.length + 1) : stack;
      var errorMessage = "Error: ".concat(message, "\n").concat(stackStr);
      this.setState({
        hasError: true,
        errorMessage: errorMessage
      });

      // Pass back the error to the consumer
      (_this$props$onError = (_this$props = this.props).onError) === null || _this$props$onError === void 0 || _this$props$onError.call(_this$props, error);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        children = _this$props2.children,
        rest = (0, _objectWithoutProperties2.default)(_this$props2, _excluded);
      var _this$state = this.state,
        hasError = _this$state.hasError,
        errorMessage = _this$state.errorMessage;
      if (hasError) {
        // You can render any custom fallback UI
        return (0, _react2.jsx)(EuiErrorMessage, (0, _extends2.default)({}, rest, {
          errorMessage: errorMessage
        }));
      }
      return children;
    }
  }]);
}(_react.Component);
/**
 * Split out into a separate styling-only component for easier use of hooks,
 * and also for internal re-use by EUI's docs/playgrounds
 */
EuiErrorBoundary.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * ReactNode to render as this component's content
       */
  children: _propTypes.default.node.isRequired,
  /**
       * Callback that fires when an error is caught. Passes back the full error
       */
  onError: _propTypes.default.func
};
var EuiErrorMessage = exports.EuiErrorMessage = function EuiErrorMessage(_ref) {
  var errorMessage = _ref.errorMessage,
    className = _ref.className,
    dataTestSubj = _ref['data-test-subj'],
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded2);
  var styles = (0, _services.useEuiMemoizedStyles)(_error_boundary.euiErrorBoundaryStyles);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: styles.euiErrorBoundary,
    className: (0, _classnames.default)('euiErrorBoundary', className),
    "data-test-subj": (0, _classnames.default)('euiErrorBoundary', dataTestSubj)
  }, rest), (0, _react2.jsx)(_code.EuiCodeBlock, null, (0, _react2.jsx)(_title.EuiTitle, {
    size: "xs"
  }, (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiErrorBoundary.error",
    default: "Error"
  }))), errorMessage));
};
EuiErrorMessage.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  errorMessage: _propTypes.default.string
};