"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LAYOUTS = exports.GUTTER_SIZES = exports.EuiFacetGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _facet_group = require("./facet_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "layout", "gutterSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var LAYOUTS = exports.LAYOUTS = ['vertical', 'horizontal'];
var GUTTER_SIZES = exports.GUTTER_SIZES = ['none', 's', 'm', 'l'];
var EuiFacetGroup = exports.EuiFacetGroup = function EuiFacetGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'm' : _ref$gutterSize,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _facet_group.euiFacetGroupStyles)(theme, layout);
  var cssStyles = [styles.euiFacetGroup, styles[gutterSize], styles[layout]];
  var classes = (0, _classnames.default)('euiFacetGroup', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), children);
};
EuiFacetGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Vertically in a column, or horizontally in one wrapping line
       */
  layout: _propTypes.default.any,
  /**
       * Distance between facet buttons.
       * Horizontal layout always adds more distance horizontally between buttons.
       */
  gutterSize: _propTypes.default.any
};