"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilterButton = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _inner_text = require("../inner_text");
var _badge = require("../badge");
var _button_empty = require("../button/button_empty");
var _filter_button = require("./filter_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "iconType", "iconSide", "color", "badgeColor", "hasActiveFilters", "numFilters", "numActiveFilters", "isDisabled", "isSelected", "type", "grow", "withNext", "textProps", "contentProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiFilterButton = exports.EuiFilterButton = function EuiFilterButton(_ref) {
  var children = _ref.children,
    className = _ref.className,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'right' : _ref$iconSide,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'text' : _ref$color,
    _ref$badgeColor = _ref.badgeColor,
    badgeColor = _ref$badgeColor === void 0 ? 'accent' : _ref$badgeColor,
    hasActiveFilters = _ref.hasActiveFilters,
    numFilters = _ref.numFilters,
    numActiveFilters = _ref.numActiveFilters,
    isDisabled = _ref.isDisabled,
    isSelected = _ref.isSelected,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    withNext = _ref.withNext,
    textProps = _ref.textProps,
    contentProps = _ref.contentProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var numFiltersDefined = numFilters != null; // != instead of !== to allow for null and undefined
  var numActiveFiltersDefined = numActiveFilters != null && numActiveFilters > 0;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _filter_button.euiFilterButtonStyles)(euiTheme);
  var cssStyles = [styles.euiFilterButton, withNext && styles.withNext, !grow && styles.noGrow, hasActiveFilters && styles.hasActiveFilters, numFiltersDefined && styles.hasNotification];
  var _euiFilterButtonChild = (0, _filter_button.euiFilterButtonChildStyles)(euiTheme),
    contentStyles = _euiFilterButtonChild.content,
    textStyles = _euiFilterButtonChild.text,
    notificationStyles = _euiFilterButtonChild.notification;
  var classes = (0, _classnames.default)('euiFilterButton', {
    'euiFilterButton-isSelected': isSelected,
    'euiFilterButton-hasActiveFilters': hasActiveFilters,
    'euiFilterButton-hasNotification': numFiltersDefined
  }, className);

  /**
   * Badge
   */
  var showBadge = numFiltersDefined || numActiveFiltersDefined;
  var badgeCount = numActiveFilters || numFilters;
  var activeBadgeLabel = (0, _i18n.useEuiI18n)('euiFilterButton.filterBadgeActiveAriaLabel', '{count} active filters', {
    count: badgeCount
  });
  var availableBadgeLabel = (0, _i18n.useEuiI18n)('euiFilterButton.filterBadgeAvailableAriaLabel', '{count} available filters', {
    count: badgeCount
  });
  var badgeContent = showBadge && (0, _react2.jsx)(_badge.EuiNotificationBadge, {
    className: "euiFilterButton__notification",
    css: [notificationStyles.euiFilterButton__notification, isDisabled && notificationStyles.disabled, ";label:badgeContent;"],
    "aria-label": hasActiveFilters ? activeBadgeLabel : availableBadgeLabel,
    color: isDisabled || !hasActiveFilters ? 'subdued' : badgeColor,
    role: "marquee" // https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/marquee_role
  }, badgeCount);

  /**
   * Text
   */
  var buttonTextClassNames = (0, _classnames.default)('euiFilterButton__text', {
    'euiFilterButton__text-hasNotification': showBadge
  }, textProps && textProps.className);
  var textCssStyles = [textStyles.euiFilterButton__text, showBadge && textStyles.hasNotification, textProps && textProps.css];
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  var dataText = children && typeof children === 'string' ? children : innerText;
  var textContent = (0, _react2.jsx)("span", (0, _extends2.default)({
    ref: ref,
    "data-text": dataText,
    title: dataText
  }, textProps, {
    className: buttonTextClassNames,
    css: textCssStyles
  }), children);
  return (0, _react2.jsx)(_button_empty.EuiButtonEmpty, (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    color: color,
    isDisabled: isDisabled,
    iconSide: iconSide,
    iconType: iconType,
    type: type,
    textProps: false,
    contentProps: _objectSpread(_objectSpread({}, contentProps), {}, {
      css: [contentStyles.euiFilterButton__content, iconType && contentStyles.hasIcon, contentProps === null || contentProps === void 0 ? void 0 : contentProps.css]
    })
  }, rest), textContent, badgeContent);
};
EuiFilterButton.propTypes = {
  /**
     * Bolds the button if true
     */
  hasActiveFilters: _propTypes.default.bool,
  /**
     * Pass the total number of filters available and it will
     * add a subdued notification badge showing the number
     */
  numFilters: _propTypes.default.number,
  /**
     * Pass the number of selected filters and it will
     * add a bright notification badge showing the number
     */
  numActiveFilters: _propTypes.default.number,
  /**
     * Applies a visual state to the button useful when using with a popover.
     */
  isSelected: _propTypes.default.bool,
  /**
     * Should the button grow to fill its container, best used for dropdown buttons
     */
  grow: _propTypes.default.bool,
  /**
     * Remove border after button, good for opposite filters
     */
  withNext: _propTypes.default.bool,
  /**
     * Change color of the counter badge
     */
  badgeColor: _propTypes.default.any
};