"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JUSTIFY_CONTENTS = exports.GUTTER_SIZES = exports.EuiFlexGroup = exports.DIRECTIONS = exports.ALIGN_ITEMS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flex_group = require("./flex_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "component", "gutterSize", "alignItems", "responsive", "justifyContent", "direction", "wrap"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var GUTTER_SIZES = exports.GUTTER_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
var ALIGN_ITEMS = exports.ALIGN_ITEMS = ['stretch', 'flexStart', 'flexEnd', 'center', 'baseline'];
var JUSTIFY_CONTENTS = exports.JUSTIFY_CONTENTS = ['flexStart', 'flexEnd', 'center', 'spaceBetween', 'spaceAround', 'spaceEvenly'];
var DIRECTIONS = exports.DIRECTIONS = ['row', 'rowReverse', 'column', 'columnReverse'];
var EuiFlexGroupInternal = function EuiFlexGroupInternal(_ref, ref) {
  var className = _ref.className,
    _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
    _ref$alignItems = _ref.alignItems,
    alignItems = _ref$alignItems === void 0 ? 'stretch' : _ref$alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    _ref$justifyContent = _ref.justifyContent,
    justifyContent = _ref$justifyContent === void 0 ? 'flexStart' : _ref$justifyContent,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    _ref$wrap = _ref.wrap,
    wrap = _ref$wrap === void 0 ? false : _ref$wrap,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_flex_group.euiFlexGroupStyles);
  var cssStyles = [styles.euiFlexGroup, responsive && !direction.includes('column') && styles.responsive, wrap && styles.wrap, styles.gutterSizes[gutterSize], styles.justifyContent[justifyContent], styles.alignItems[alignItems], styles.direction[direction]];
  var classes = (0, _classnames.default)('euiFlexGroup', className);

  // Cast `component` to FunctionComponent to simplify its type.
  // Note that FunctionComponent type is used here for purely typing
  // convenience since we specify the return type above, and function
  // components don't support `ref`s, but that doesn't matter in this case.
  var Component = component;
  return (0, _react2.jsx)(Component, (0, _extends2.default)({}, rest, {
    ref: ref,
    className: classes,
    css: cssStyles
  }));
};

// Cast forwardRef return type to work with the generic TComponent type
// and not fallback to implicit any typing
var EuiFlexGroup = exports.EuiFlexGroup = /*#__PURE__*/(0, _react.forwardRef)(EuiFlexGroupInternal);
EuiFlexGroup.displayName = 'EuiFlexGroup';