"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _flyout = require("./flyout");
var _button = require("../button");
var _react2 = require("@emotion/react");
var _excluded = ["children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var childrenDefault = (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("button", {
  "data-test-subj": "itemA"
}, "Item A"), (0, _react2.jsx)("button", {
  "data-test-subj": "itemB"
}, "Item B"), (0, _react2.jsx)("button", {
  "data-test-subj": "itemC"
}, "Item C"), (0, _react2.jsx)("input", {
  "data-test-subj": "itemD"
}));
var Flyout = function Flyout(_ref) {
  var _ref$children = _ref.children,
    children = _ref$children === void 0 ? childrenDefault : _ref$children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var onButtonClick = function onButtonClick() {
    return setIsOpen(!isOpen);
  };
  var button = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    onClick: onButtonClick
  }, "Toggle flyout");
  return (0, _react2.jsx)("div", null, button, isOpen ? (0, _react2.jsx)(_flyout.EuiFlyout, (0, _extends2.default)({
    "data-test-subj": "flyoutSpec",
    onClose: function onClose() {
      return setIsOpen(false);
    }
  }, rest), children) : null);
};
beforeEach(function () {
  cy.mount((0, _react2.jsx)(Flyout, null));
  cy.get('div.euiFlyout').should('not.exist');
});
describe('EuiFlyout', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when flyout is opened', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiFlyout').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when flyout is closed', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiFlyout').should('exist');
      cy.get('button.euiFlyout__closeButton').click();
      cy.get('div.euiFlyout').should('not.exist');
      cy.checkAxe();
    });
  });
});