"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutResizable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _resizable_container = require("../resizable_container");
var _helpers = require("../resizable_container/helpers");
var _flyout = require("./flyout");
var _flyout_resizable = require("./flyout_resizable.styles");
var _react2 = require("@emotion/react");
var _excluded = ["size", "maxWidth", "minWidth", "onResize", "side", "type", "ownFocus", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// If not omitted, the correct props don't show up in the docs prop table

var EuiFlyoutResizable = exports.EuiFlyoutResizable = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var size = _ref.size,
    maxWidth = _ref.maxWidth,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 200 : _ref$minWidth,
    onResize = _ref.onResize,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'right' : _ref$side,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'overlay' : _ref$type,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
    children = _ref.children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var hasOverlay = type === 'overlay' && ownFocus;
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_resizable.euiFlyoutResizableButtonStyles);
  var cssStyles = [styles.euiFlyoutResizableButton, styles[type][side], !hasOverlay && styles.noOverlay.noOverlay, !hasOverlay && styles.noOverlay[side]];
  var getFlyoutMinMaxWidth = (0, _react.useCallback)(function (width) {
    return Math.min(Math.max(width, minWidth), maxWidth || Infinity, window.innerWidth - 20 // Leave some offset
    );
  }, [minWidth, maxWidth]);
  var _useState = (0, _react.useState)(0),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    flyoutWidth = _useState2[0],
    setFlyoutWidth = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    callOnResize = _useState4[0],
    setCallOnResize = _useState4[1];

  // Must use state for the flyout ref in order for the useEffect to be correctly called after render
  var _useState5 = (0, _react.useState)(null),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    flyoutRef = _useState6[0],
    setFlyoutRef = _useState6[1];
  var setRefs = (0, _services.useCombinedRefs)([setFlyoutRef, ref]);
  (0, _react.useEffect)(function () {
    if (!flyoutWidth && flyoutRef) {
      setCallOnResize(false); // Don't call `onResize` for non-user width changes
      setFlyoutWidth(getFlyoutMinMaxWidth(flyoutRef.offsetWidth));
    }
  }, [flyoutWidth, flyoutRef, getFlyoutMinMaxWidth]);

  // Update flyout width when consumers pass in a new `size`
  (0, _react.useEffect)(function () {
    setCallOnResize(false);
    // For string `size`s, resetting flyoutWidth to 0 will trigger the above useEffect's recalculation
    setFlyoutWidth(typeof size === 'number' ? getFlyoutMinMaxWidth(size) : 0);
  }, [size, getFlyoutMinMaxWidth]);

  // Initial numbers to calculate from, on resize drag start
  var initialWidth = (0, _react.useRef)(0);
  var initialMouseX = (0, _react.useRef)(0);

  // Account for flyout side and logical property direction
  var direction = (0, _react.useMemo)(function () {
    var modifier = side === 'right' ? -1 : 1;
    if (flyoutRef) {
      var languageDirection = window.getComputedStyle(flyoutRef).direction;
      if (languageDirection === 'rtl') modifier *= -1;
    }
    return modifier;
  }, [side, flyoutRef]);
  var onMouseMove = (0, _react.useCallback)(function (e) {
    var mouseOffset = (0, _helpers.getPosition)(e, true) - initialMouseX.current;
    var changedFlyoutWidth = initialWidth.current + mouseOffset * direction;
    setFlyoutWidth(getFlyoutMinMaxWidth(changedFlyoutWidth));
  }, [getFlyoutMinMaxWidth, direction]);
  var onMouseUp = (0, _react.useCallback)(function () {
    setCallOnResize(true);
    initialMouseX.current = 0;
    window.removeEventListener('mousemove', onMouseMove);
    window.removeEventListener('mouseup', onMouseUp);
    window.removeEventListener('touchmove', onMouseMove);
    window.removeEventListener('touchend', onMouseUp);
  }, [onMouseMove]);
  var onMouseDown = (0, _react.useCallback)(function (e) {
    var _flyoutRef$offsetWidt;
    setCallOnResize(false);
    initialMouseX.current = (0, _helpers.getPosition)(e, true);
    initialWidth.current = (_flyoutRef$offsetWidt = flyoutRef === null || flyoutRef === void 0 ? void 0 : flyoutRef.offsetWidth) !== null && _flyoutRef$offsetWidt !== void 0 ? _flyoutRef$offsetWidt : 0;

    // Window event listeners instead of React events are used
    // in case the user's mouse leaves the component
    window.addEventListener('mousemove', onMouseMove);
    window.addEventListener('mouseup', onMouseUp);
    window.addEventListener('touchmove', onMouseMove);
    window.addEventListener('touchend', onMouseUp);
  }, [flyoutRef, onMouseMove, onMouseUp]);
  var onKeyDown = (0, _react.useCallback)(function (e) {
    setCallOnResize(true);
    var KEYBOARD_OFFSET = 10;
    switch (e.key) {
      case _services.keys.ARROW_RIGHT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth + KEYBOARD_OFFSET * direction);
        });
        break;
      case _services.keys.ARROW_LEFT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth - KEYBOARD_OFFSET * direction);
        });
    }
  }, [getFlyoutMinMaxWidth, direction]);

  // To reduce unnecessary calls, only fire onResize callback:
  // 1. After initial mount / on user width change events only
  // 2. If not currently mouse dragging
  (0, _react.useEffect)(function () {
    if (callOnResize) {
      onResize === null || onResize === void 0 || onResize(flyoutWidth);
    }
  }, [onResize, callOnResize, flyoutWidth]);
  return (0, _react2.jsx)(_flyout.EuiFlyout, (0, _extends2.default)({}, rest, {
    size: flyoutWidth || size,
    maxWidth: maxWidth,
    side: side,
    type: type,
    ownFocus: ownFocus,
    ref: setRefs
  }), (0, _react2.jsx)(_resizable_container.EuiResizableButton, {
    isHorizontal: true,
    indicator: "border",
    css: cssStyles,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    onKeyDown: onKeyDown
  }), children);
});
EuiFlyoutResizable.displayName = 'EuiFlyoutResizable';