"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCheckbox = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _icon = require("../../icon");
var _checkbox = require("./checkbox.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "id", "checked", "label", "onChange", "type", "disabled", "readOnly", "indeterminate", "inputRef", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiCheckbox = exports.EuiCheckbox = function EuiCheckbox(_ref) {
  var className = _ref.className,
    id = _ref.id,
    _ref$checked = _ref.checked,
    checked = _ref$checked === void 0 ? false : _ref$checked,
    label = _ref.label,
    onChange = _ref.onChange,
    type = _ref.type,
    _ref$disabled = _ref.disabled,
    disabled = _ref$disabled === void 0 ? false : _ref$disabled,
    _ref$readOnly = _ref.readOnly,
    readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
    _ref$indeterminate = _ref.indeterminate,
    indeterminate = _ref$indeterminate === void 0 ? false : _ref$indeterminate,
    inputRef = _ref.inputRef,
    labelProps = _ref.labelProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCheckbox', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_checkbox.euiCheckboxStyles);
  var inputStyles = [styles.input.euiCheckbox__square, !!label && styles.input.hasLabel, disabled ? checked || indeterminate ? styles.input.disabled.selected : styles.input.disabled.unselected : checked || indeterminate ? styles.input.enabled.selected : styles.input.enabled.unselected, readOnly && styles.input.readOnly];
  var labelClasses = (0, _classnames.default)('euiCheckbox__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var labelStyles = [styles.label.euiCheckbox__label, disabled ? styles.label.disabled : styles.label.enabled, readOnly && styles.label.readOnly, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  var iconStyles = [styles.input.icon.euiCheckbox__icon, indeterminate ? styles.input.icon.indeterminate : styles.input.icon.check];

  // @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/checkbox#indeterminate_state_checkboxes
  var setIndeterminateState = (0, _react.useCallback)(function (input) {
    if (input) input.indeterminate = indeterminate;
  }, [indeterminate]);
  var refs = (0, _services.useCombinedRefs)([inputRef, setIndeterminateState]);
  return (0, _react2.jsx)("div", {
    css: styles.euiCheckbox,
    className: classes
  }, (0, _react2.jsx)("div", {
    css: inputStyles,
    className: "euiCheckbox__square"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    css: iconStyles,
    type: indeterminate ? 'stopFilled' : checked ? 'check' : 'empty'
  }), (0, _react2.jsx)("input", (0, _extends2.default)({
    css: styles.input.euiCheckbox__input,
    className: "euiCheckbox__input",
    type: "checkbox",
    id: id,
    checked: checked,
    onChange: onChange,
    disabled: disabled,
    readOnly: readOnly,
    ref: refs
  }, rest))), label && (0, _react2.jsx)("label", (0, _extends2.default)({}, labelProps, {
    css: labelStyles,
    className: labelClasses,
    htmlFor: id
  }), label));
};
EuiCheckbox.propTypes = {
  id: _propTypes.default.string.isRequired,
  checked: _propTypes.default.bool,
  onChange: _propTypes.default.any.isRequired,
  // overriding to make it required
  inputRef: _propTypes.default.func,
  label: _propTypes.default.node,
  disabled: _propTypes.default.bool,
  indeterminate: _propTypes.default.bool,
  /**
     * Object of props passed to the <label/>
     */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};