"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCheckboxGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _form_fieldset = require("../form_fieldset");
var _checkbox = require("./checkbox");
var _checkbox_group = require("./checkbox_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["options", "idToSelectedMap", "onChange", "className", "disabled", "compressed", "legend"],
  _excluded2 = ["disabled", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Must omit inherit `onChange` properties or else TS complains when applying to the EuiRadio
var EuiCheckboxGroup = exports.EuiCheckboxGroup = function EuiCheckboxGroup(_ref) {
  var _ref$options = _ref.options,
    options = _ref$options === void 0 ? [] : _ref$options,
    _ref$idToSelectedMap = _ref.idToSelectedMap,
    idToSelectedMap = _ref$idToSelectedMap === void 0 ? {} : _ref$idToSelectedMap,
    onChange = _ref.onChange,
    className = _ref.className,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    legend = _ref.legend,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCheckboxGroup', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_checkbox_group.euiCheckboxGroupStyles);
  var cssStyles = [styles.euiCheckboxGroup, compressed ? styles.compressed : styles.uncompressed];
  var checkboxes = options.map(function (option, index) {
    var isOptionDisabled = option.disabled,
      optionClass = option.className,
      optionRest = (0, _objectWithoutProperties2.default)(option, _excluded2);
    return (0, _react2.jsx)(_checkbox.EuiCheckbox, (0, _extends2.default)({
      className: (0, _classnames.default)('euiCheckboxGroup__item', optionClass),
      key: index,
      checked: idToSelectedMap[option.id],
      disabled: disabled || isOptionDisabled,
      onChange: onChange.bind(null, option.id)
    }, optionRest));
  });
  if (!!legend) {
    // Be sure to pass down the compressed option to the legend
    legend.compressed = compressed;
    return (0, _react2.jsx)(_form_fieldset.EuiFormFieldset, (0, _extends2.default)({
      css: cssStyles,
      className: classes,
      legend: legend
    }, rest), checkboxes);
  }
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), checkboxes);
};
EuiCheckboxGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  idToSelectedMap: _propTypes.default.shape({}).isRequired,
  onChange: _propTypes.default.func.isRequired,
  /**
     * Tightens up the spacing between checkbox rows
     */
  compressed: _propTypes.default.bool,
  /**
     * Passed down to all child `EuiCheckbox`es
     */
  disabled: _propTypes.default.bool,
  /**
     * If the individual labels for each radio do not provide a sufficient description, add a legend.
     * Wraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.
     * Accepts an `EuiFormLegendProps` shape.
     */
  legend: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
         * ReactNode to render as this component's content
         */
    children: _propTypes.default.node.isRequired,
    /**
         * For a hidden legend that is still visible to the screen reader, set to 'hidden'
         */
    display: _propTypes.default.oneOf(["hidden", "visible"]),
    compressed: _propTypes.default.bool
  })
};