"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDescribedFormGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _title = require("../../title");
var _text = require("../../text");
var _flex = require("../../flex");
var _eui_form_context = require("../eui_form_context");
var _described_form_group = require("./described_form_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "gutterSize", "fullWidth", "ratio", "titleSize", "title", "description", "descriptionFlexItemProps", "fieldFlexItemProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiDescribedFormGroup = exports.EuiDescribedFormGroup = function EuiDescribedFormGroup(props) {
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var children = props.children,
    className = props.className,
    _props$gutterSize = props.gutterSize,
    gutterSize = _props$gutterSize === void 0 ? 'l' : _props$gutterSize,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$ratio = props.ratio,
    ratio = _props$ratio === void 0 ? 'half' : _props$ratio,
    _props$titleSize = props.titleSize,
    titleSize = _props$titleSize === void 0 ? 'xs' : _props$titleSize,
    title = props.title,
    description = props.description,
    descriptionFlexItemProps = props.descriptionFlexItemProps,
    fieldFlexItemProps = props.fieldFlexItemProps,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_described_form_group.euiDescribedFormGroupStyles);
  var cssStyles = [styles.euiDescribedFormGroup, fullWidth ? styles.fullWidth : styles.formWidth];
  var descriptionColumnStyles = [styles.euiDescribedFormGroup__descriptionColumn, descriptionFlexItemProps === null || descriptionFlexItemProps === void 0 ? void 0 : descriptionFlexItemProps.css];
  var fieldColumnStyles = [styles.euiDescribedFormGroup__fields, fieldFlexItemProps === null || fieldFlexItemProps === void 0 ? void 0 : fieldFlexItemProps.css];
  var classes = (0, _classnames.default)('euiDescribedFormGroup', className);
  var fieldClasses = (0, _classnames.default)('euiDescribedFormGroup__fields', fieldFlexItemProps && fieldFlexItemProps.className);
  var renderedDescription;
  if (description) {
    renderedDescription = (0, _react2.jsx)(_text.EuiText, {
      size: "s",
      color: "subdued",
      css: styles.euiDescribedFormGroup__description,
      className: "euiDescribedFormGroup__description"
    },
    // If the description is just a string, wrap it in a paragraph element
    typeof description === 'string' ? (0, _react2.jsx)("p", null, description) : description);
  }
  var fieldGrowth;
  switch (ratio) {
    case 'half':
      fieldGrowth = 1;
      break;
    case 'third':
      fieldGrowth = 2;
      break;
    case 'quarter':
      fieldGrowth = 3;
      break;
    default:
      console.warn('Please provide an allowed ratio to EuiDescribedFromRow');
      break;
  }
  return (0, _react2.jsx)(_flex.EuiFlexGroup, (0, _extends2.default)({
    role: "group"
  }, rest, {
    css: cssStyles,
    className: classes,
    alignItems: "baseline",
    gutterSize: gutterSize
  }), (0, _react2.jsx)(_flex.EuiFlexItem, (0, _extends2.default)({
    grow: 1
  }, descriptionFlexItemProps, {
    css: descriptionColumnStyles,
    className: (0, _classnames.default)('euiDescribedFormGroup__descriptionColumn', descriptionFlexItemProps === null || descriptionFlexItemProps === void 0 ? void 0 : descriptionFlexItemProps.className)
  }), (0, _react2.jsx)(_title.EuiTitle, {
    size: titleSize,
    className: "euiDescribedFormGroup__title"
  }, title), renderedDescription), (0, _react2.jsx)(_flex.EuiFlexItem, (0, _extends2.default)({
    grow: fieldGrowth
  }, fieldFlexItemProps, {
    css: fieldColumnStyles,
    className: fieldClasses
  }), children));
};
EuiDescribedFormGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * One or more `EuiFormRow`s.
       */
  children: _propTypes.default.node,
  /**
       * Passed to `EuiFlexGroup`.
       * @default l
       */
  gutterSize: _propTypes.default.any,
  /**
       * Expand to fill 100% of the parent.
       * Defaults to `fullWidth` prop of `<EuiForm>`.
       * Default max-width is 800px.
       * @default false
       */
  fullWidth: _propTypes.default.bool,
  /**
       * Width ratio of description column compared to field column.
       * Can be used in conjunction with `fullWidth` and
       * may require `fullWidth` to be applied to child elements.
       * @default half
       */
  ratio: _propTypes.default.oneOf(["half", "third", "quarter"]),
  /**
       * For better accessibility, it's recommended to use an HTML heading.
       */
  title: _propTypes.default.element.isRequired,
  /**
       * Adjust the visual `size` of the EuiTitle that wraps `title`.
       * @default xs
       */
  titleSize: _propTypes.default.any,
  /**
       * Added as a child of `EuiText`.
       */
  description: _propTypes.default.node,
  /**
       * For customizing the field container. Extended from `EuiFlexItem`.
       */
  descriptionFlexItemProps: _propTypes.default.any,
  fieldFlexItemProps: _propTypes.default.any
};