"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFieldPassword = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _button = require("../../button");
var _form_control_layout = require("../form_control_layout");
var _validatable_control = require("../validatable_control");
var _eui_form_context = require("../eui_form_context");
var _field_password = require("./field_password.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "id", "name", "placeholder", "value", "disabled", "isInvalid", "fullWidth", "isLoading", "compressed", "inputRef", "prepend", "append", "type", "dualToggleProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiFieldPassword = exports.EuiFieldPassword = function EuiFieldPassword(props) {
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var className = props.className,
    id = props.id,
    name = props.name,
    placeholder = props.placeholder,
    value = props.value,
    disabled = props.disabled,
    isInvalid = props.isInvalid,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$isLoading = props.isLoading,
    isLoading = _props$isLoading === void 0 ? false : _props$isLoading,
    _props$compressed = props.compressed,
    compressed = _props$compressed === void 0 ? false : _props$compressed,
    _inputRef = props.inputRef,
    prepend = props.prepend,
    append = props.append,
    _props$type = props.type,
    type = _props$type === void 0 ? 'password' : _props$type,
    dualToggleProps = props.dualToggleProps,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);

  // Set the initial input type to `password` if they want dual
  var _useState = (0, _react.useState)(type === 'dual' ? 'password' : type),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    inputType = _useState2[0],
    setInputType = _useState2[1];

  // Setup toggle aria-label
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiFieldPassword.showPassword', 'euiFieldPassword.maskPassword'], ['Show password as plain text. Note: this will visually expose your password on the screen.', 'Mask password']),
    _useEuiI18n2 = (0, _slicedToArray2.default)(_useEuiI18n, 2),
    showPasswordLabel = _useEuiI18n2[0],
    maskPasswordLabel = _useEuiI18n2[1];

  // Setup the inputRef to auto-focus when toggling visibility
  var _useState3 = (0, _react.useState)(null),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    inputRef = _useState4[0],
    _setInputRef = _useState4[1];
  var setInputRef = (0, _services.useCombinedRefs)([_setInputRef, _inputRef]);
  var handleToggle = (0, _react.useCallback)(function (event, isVisible) {
    var _dualToggleProps$onCl;
    setInputType(isVisible ? 'password' : 'text');
    inputRef === null || inputRef === void 0 || inputRef.focus();
    dualToggleProps === null || dualToggleProps === void 0 || (_dualToggleProps$onCl = dualToggleProps.onClick) === null || _dualToggleProps$onCl === void 0 || _dualToggleProps$onCl.call(dualToggleProps, event);
  }, [inputRef, dualToggleProps]);

  // Add a toggling button to switch between `password` and `input` if consumer wants `dual`
  // https://www.w3schools.com/howto/howto_js_toggle_password.asp
  var visibilityToggle = (0, _react.useMemo)(function () {
    if (type === 'dual') {
      var isVisible = inputType === 'text';
      return (0, _react2.jsx)(_button.EuiButtonIcon, (0, _extends2.default)({
        iconType: isVisible ? 'eyeClosed' : 'eye',
        "aria-label": isVisible ? maskPasswordLabel : showPasswordLabel,
        title: isVisible ? maskPasswordLabel : showPasswordLabel,
        disabled: disabled
      }, dualToggleProps, {
        onClick: function onClick(e) {
          return handleToggle(e, isVisible);
        }
      }));
    }
  }, [type, inputType, maskPasswordLabel, showPasswordLabel, dualToggleProps, handleToggle, disabled]);
  var finalAppend = (0, _react.useMemo)(function () {
    if (!visibilityToggle) return append;
    if (!append) return visibilityToggle;

    // Convert any `append` elements to an array so the visibility
    // toggle can be added to it
    var appendAsArray = append ? Array.isArray(append) ? append : [append] : [];
    return [].concat((0, _toConsumableArray2.default)(appendAsArray), [visibilityToggle]);
  }, [append, visibilityToggle]);
  var classes = (0, _classnames.default)('euiFieldPassword', {
    'euiFieldPassword-isLoading': isLoading
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_field_password.euiFieldPasswordStyles);
  var cssStyles = [styles.euiFieldPassword, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, (finalAppend || prepend) && styles.inGroup, type === 'dual' && styles.withToggle];
  return (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, {
    icon: "lock",
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: disabled,
    compressed: compressed,
    prepend: prepend,
    append: finalAppend
  }, (0, _react2.jsx)(_validatable_control.EuiValidatableControl, {
    isInvalid: isInvalid
  }, (0, _react2.jsx)("input", (0, _extends2.default)({
    type: inputType,
    id: id,
    name: name,
    placeholder: placeholder,
    className: classes,
    css: cssStyles,
    value: value,
    disabled: disabled,
    ref: setInputRef
  }, rest))));
};
EuiFieldPassword.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  isInvalid: _propTypes.default.bool,
  /**
       * Expand to fill 100% of the parent.
       * Defaults to `fullWidth` prop of `<EuiForm>`.
       * @default false
       */
  fullWidth: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  compressed: _propTypes.default.bool,
  inputRef: _propTypes.default.any,
  /**
       * Creates an input group with element(s) coming before input.
       * `string` | `ReactElement` or an array of these
       */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
       * Creates an input group with element(s) coming after input.
       * `string` | `ReactElement` or an array of these
       */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  /**
       * Change the `type` of input for manually handling obfuscation.
       * The `dual` option adds the ability to toggle the obfuscation of the input by
       * adding an icon button as the first `append` element
       * @default password
       */
  type: _propTypes.default.oneOf(["password", "text", "dual"]),
  /**
       * Additional props to apply to the dual toggle. Extends EuiButtonIcon
       */
  dualToggleProps: _propTypes.default.any
};