"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFieldSearchClass = exports.EuiFieldSearch = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _browser = require("../../../services/browser");
var _i18n = require("../../i18n");
var _form_control_layout = require("../form_control_layout");
var _validatable_control = require("../validatable_control");
var _eui_form_context = require("../eui_form_context");
var _field_search = require("./field_search.styles");
var _react2 = require("@emotion/react");
var _excluded = ["stylesMemoizer", "className", "id", "name", "placeholder", "isInvalid", "disabled", "fullWidth", "isLoading", "inputRef", "incremental", "compressed", "onSearch", "isClearable", "append", "prepend"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var isSearchSupported = false;
var EuiFieldSearchClass = exports.EuiFieldSearchClass = /*#__PURE__*/function (_Component) {
  function EuiFieldSearchClass() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiFieldSearchClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFieldSearchClass, [].concat(args));
    (0, _defineProperty2.default)(_this, "state", {
      value: _this.props.value || String(_this.props.defaultValue || '')
    });
    (0, _defineProperty2.default)(_this, "inputElement", null);
    (0, _defineProperty2.default)(_this, "cleanups", []);
    (0, _defineProperty2.default)(_this, "onClear", function () {
      // clear the field's value

      // 1. React doesn't listen for `change` events, instead it maps `input` events to `change`
      // 2. React only fires the mapped `change` event if the element's value has changed
      // 3. An input's value is, in addition to other methods, tracked by intercepting element.value = '...'
      //
      // So we have to go below the element's value setter to avoid React intercepting it,
      // only then will React treat the value as different and fire its `change` event
      //
      // https://stackoverflow.com/questions/23892547/what-is-the-best-way-to-trigger-onchange-event-in-react-js
      var nativeInputValue = Object.getOwnPropertyDescriptor(HTMLInputElement.prototype, 'value');
      var nativeInputValueSetter = nativeInputValue ? nativeInputValue.set : undefined;
      if (nativeInputValueSetter) {
        nativeInputValueSetter.call(_this.inputElement, '');
      }

      // dispatch input event
      var event = new Event('input', {
        bubbles: true,
        cancelable: false
      });
      if (_this.inputElement) {
        _this.inputElement.dispatchEvent(event);
        // set focus on the search field
        _this.inputElement.focus();
        _this.inputElement.dispatchEvent(new Event('change'));
      }
      _this.setState({
        value: ''
      });
      var _this$props = _this.props,
        incremental = _this$props.incremental,
        onSearch = _this$props.onSearch;
      if (onSearch && incremental) {
        onSearch('');
      }
    });
    (0, _defineProperty2.default)(_this, "setRef", function (inputElement) {
      _this.inputElement = inputElement;
      if (_this.props.inputRef) {
        _this.props.inputRef(inputElement);
      }
    });
    (0, _defineProperty2.default)(_this, "onKeyUp", function (event, incremental, onSearch) {
      _this.setState({
        value: event.target.value
      });
      if (_this.props.onKeyUp) {
        _this.props.onKeyUp(event);
        if (event.defaultPrevented) {
          return;
        }
      }
      if (onSearch && (event.key !== _services.keys.ENTER && incremental || event.key === _services.keys.ENTER && !isSearchSupported)) {
        onSearch(event.target.value);
      }
    });
    return _this;
  }
  (0, _inherits2.default)(EuiFieldSearchClass, _Component);
  return (0, _createClass2.default)(EuiFieldSearchClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      if (!this.inputElement) return;
      isSearchSupported = _browser.Browser.isEventSupported('search', this.inputElement);
      if (isSearchSupported) {
        var onSearch = function onSearch(event) {
          if (_this2.props.onSearch) {
            if (!event || !event.target || event.defaultPrevented) return;
            _this2.props.onSearch(event.target.value);
          }
        };
        this.inputElement.addEventListener('search', onSearch);
        this.cleanups.push(function () {
          if (!_this2.inputElement) return;
          _this2.inputElement.removeEventListener('search', onSearch);
        });
      }
      var onChange = function onChange(event) {
        if (event.target && event.target.value !== _this2.state.value) {
          _this2.setState({
            value: event.target.value
          });
          if (_this2.props.onSearch) {
            _this2.props.onSearch(event.target.value);
          }
        }
      };
      this.inputElement.addEventListener('change', onChange);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.cleanups.forEach(function (cleanup) {
        return cleanup();
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var _ref = this.context,
        defaultFullWidth = _ref.defaultFullWidth;
      var _this$props2 = this.props,
        stylesMemoizer = _this$props2.stylesMemoizer,
        className = _this$props2.className,
        id = _this$props2.id,
        name = _this$props2.name,
        placeholder = _this$props2.placeholder,
        isInvalid = _this$props2.isInvalid,
        disabled = _this$props2.disabled,
        _this$props2$fullWidt = _this$props2.fullWidth,
        fullWidth = _this$props2$fullWidt === void 0 ? defaultFullWidth : _this$props2$fullWidt,
        isLoading = _this$props2.isLoading,
        inputRef = _this$props2.inputRef,
        incremental = _this$props2.incremental,
        compressed = _this$props2.compressed,
        onSearch = _this$props2.onSearch,
        _isClearable = _this$props2.isClearable,
        append = _this$props2.append,
        prepend = _this$props2.prepend,
        rest = (0, _objectWithoutProperties2.default)(_this$props2, _excluded);
      var value = this.props.value;
      if (typeof this.props.value !== 'string') value = this.state.value;

      // Set actual value of isClearable if value exists as well
      var isClearable = Boolean(_isClearable && value && !rest.readOnly && !disabled);
      var classes = (0, _classnames.default)('euiFieldSearch', {
        'euiFieldSearch-isLoading': isLoading,
        'euiFieldSearch-isClearable': isClearable,
        'euiFieldSearch-isInvalid': isInvalid
      }, className);
      var styles = stylesMemoizer(_field_search.euiFieldSearchStyles);
      var cssStyles = [styles.euiFieldSearch, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, (prepend || append) && styles.inGroup];
      return (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiFieldSearch.clearSearchButtonLabel",
        default: "Clear search input"
      }, function (clearSearchButtonLabel) {
        return (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, {
          icon: "search",
          fullWidth: fullWidth,
          isLoading: isLoading,
          isInvalid: isInvalid,
          isDisabled: disabled,
          clear: isClearable ? {
            onClick: _this3.onClear,
            'aria-label': clearSearchButtonLabel,
            'data-test-subj': 'clearSearchButton'
          } : undefined,
          compressed: compressed,
          append: append,
          prepend: prepend
        }, (0, _react2.jsx)(_validatable_control.EuiValidatableControl, {
          isInvalid: isInvalid
        }, (0, _react2.jsx)("input", (0, _extends2.default)({
          type: "search",
          id: id,
          name: name,
          placeholder: placeholder,
          className: classes,
          css: cssStyles,
          onKeyUp: function onKeyUp(e) {
            return _this3.onKeyUp(e, incremental, onSearch);
          },
          disabled: disabled,
          ref: _this3.setRef
        }, rest))));
      });
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiFieldSearchClass, "contextType", _eui_form_context.FormContext);
(0, _defineProperty2.default)(EuiFieldSearchClass, "defaultProps", {
  isLoading: false,
  incremental: false,
  compressed: false,
  isClearable: true
});
EuiFieldSearchClass.propTypes = {
  name: _propTypes.default.string,
  id: _propTypes.default.string,
  placeholder: _propTypes.default.string,
  value: _propTypes.default.string,
  isInvalid: _propTypes.default.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  /**
     * Called when the user presses [Enter] OR on change if the incremental prop is `true`.
     * If you don't need the on[Enter] functionality, prefer using onChange
     */
  onSearch: _propTypes.default.func,
  /**
     * When `true` the search will be executed (that is, the `onSearch` will be called) as the
     * user types.
     */
  incremental: _propTypes.default.bool,
  /**
     * when `true` creates a shorter height input
     */
  compressed: _propTypes.default.bool,
  inputRef: _propTypes.default.func,
  /**
     * Shows a button that quickly clears any input
     */
  isClearable: _propTypes.default.bool,
  /**
     * Creates an input group with element(s) coming before input
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Creates an input group with element(s) coming after input.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
var EuiFieldSearch = exports.EuiFieldSearch = (0, _services.withEuiStylesMemoizer)(EuiFieldSearchClass);