"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormLegend = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _accessibility = require("../../accessibility");
var _form_legend = require("./form_legend.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "display", "compressed"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiFormLegend = exports.EuiFormLegend = function EuiFormLegend(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'visible' : _ref$display,
    compressed = _ref.compressed,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isLegendHidden = display === 'hidden';
  var styles = (0, _services.useEuiMemoizedStyles)(_form_legend.euiFormLegendStyles);
  var cssStyles = [styles.euiFormLegend, !isLegendHidden && (compressed ? styles.compressed : styles.uncompressed)];
  var classes = (0, _classnames.default)('euiFormLegend', {
    'euiFormLegend-isHidden': isLegendHidden
  }, className);
  return (0, _react2.jsx)("legend", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), isLegendHidden ? (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, children)) : children);
};
EuiFormLegend.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * ReactNode to render as this component's content
       */
  children: _propTypes.default.node.isRequired,
  /**
       * For a hidden legend that is still visible to the screen reader, set to 'hidden'
       */
  display: _propTypes.default.oneOf(["hidden", "visible"]),
  compressed: _propTypes.default.bool
};