"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormRow = exports.DISPLAYS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _spacer = require("../../spacer");
var _form_help_text = require("../form_help_text");
var _form_error_text = require("../form_error_text");
var _form_label = require("../form_label");
var _eui_form_context = require("../eui_form_context");
var _form_row = require("./form_row.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children", "helpText", "isInvalid", "error", "label", "labelType", "labelAppend", "hasEmptyLabelSpace", "fullWidth", "describedByIds", "display", "hasChildLabel", "id", "isDisabled"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var DISPLAYS = exports.DISPLAYS = ['row', 'columnCompressed', 'center', 'centerCompressed',
/**
 * This currently does not affect styles/appearances
 * in EUI's present primary theme, but may in the future.
 */
'rowCompressed'];
var EuiFormRow = exports.EuiFormRow = function EuiFormRow(_ref) {
  var className = _ref.className,
    children = _ref.children,
    helpText = _ref.helpText,
    isInvalid = _ref.isInvalid,
    error = _ref.error,
    label = _ref.label,
    _ref$labelType = _ref.labelType,
    labelType = _ref$labelType === void 0 ? 'label' : _ref$labelType,
    labelAppend = _ref.labelAppend,
    _ref$hasEmptyLabelSpa = _ref.hasEmptyLabelSpace,
    hasEmptyLabelSpace = _ref$hasEmptyLabelSpa === void 0 ? false : _ref$hasEmptyLabelSpa,
    _fullWidth = _ref.fullWidth,
    describedByIds = _ref.describedByIds,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'row' : _ref$display,
    _ref$hasChildLabel = _ref.hasChildLabel,
    hasChildLabel = _ref$hasChildLabel === void 0 ? true : _ref$hasChildLabel,
    propsId = _ref.id,
    isDisabled = _ref.isDisabled,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var fullWidth = _fullWidth !== null && _fullWidth !== void 0 ? _fullWidth : defaultFullWidth;
  var id = (0, _services.useGeneratedHtmlId)({
    conditionalId: propsId
  });
  var hasLabel = label || labelAppend;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isFocused = _useState2[0],
    setIsFocused = _useState2[1];
  var onFocusWithin = (0, _react.useCallback)(function () {
    return setIsFocused(true);
  }, []);
  var onBlurWithin = (0, _react.useCallback)(function () {
    return setIsFocused(false);
  }, []);
  var classes = (0, _classnames.default)('euiFormRow', {
    'euiFormRow--hasEmptyLabelSpace': hasEmptyLabelSpace,
    'euiFormRow--hasLabel': hasLabel
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_form_row.euiFormRowStyles);
  var cssStyles = [styles.euiFormRow, fullWidth ? styles.fullWidth : styles.formWidth, styles[display]];
  var optionalHelpTexts = (0, _react.useMemo)(function () {
    if (!helpText) return;
    var helpTexts = Array.isArray(helpText) ? helpText : [helpText];
    return helpTexts.map(function (helpText, i) {
      var key = typeof helpText === 'string' ? helpText : i;
      return (0, _react2.jsx)(_form_help_text.EuiFormHelpText, {
        key: key,
        id: "".concat(id, "-help-").concat(i),
        className: "euiFormRow__text"
      }, helpText);
    });
  }, [helpText, id]);
  var optionalErrors = (0, _react.useMemo)(function () {
    if (!(error && isInvalid)) return;
    var errorTexts = Array.isArray(error) ? error : [error];
    return errorTexts.map(function (error, i) {
      var key = typeof error === 'string' ? error : i;
      return (0, _react2.jsx)(_form_error_text.EuiFormErrorText, {
        key: key,
        id: "".concat(id, "-error-").concat(i),
        className: "euiFormRow__text"
      }, error);
    });
  }, [error, isInvalid, id]);
  var ariaDescribedBy = (0, _react.useMemo)(function () {
    var describingIds = (0, _toConsumableArray2.default)(describedByIds || []);
    if (optionalHelpTexts !== null && optionalHelpTexts !== void 0 && optionalHelpTexts.length) {
      optionalHelpTexts.forEach(function (optionalHelpText) {
        return describingIds.push(optionalHelpText.props.id);
      });
    }
    if (optionalErrors !== null && optionalErrors !== void 0 && optionalErrors.length) {
      optionalErrors.forEach(function (error) {
        return describingIds.push(error.props.id);
      });
    }
    if (describingIds.length) {
      return describingIds.join(' ');
    }
  }, [describedByIds, optionalHelpTexts, optionalErrors]);
  var field = (0, _react.useMemo)(function () {
    var _ref2, _child$props$disabled;
    var child = _react.Children.only(children);
    return /*#__PURE__*/(0, _react.cloneElement)(child, {
      id: id,
      // Allow the child's disabled or isDisabled prop to supercede the `isDisabled`
      disabled: (_ref2 = (_child$props$disabled = child.props.disabled) !== null && _child$props$disabled !== void 0 ? _child$props$disabled : child.props.isDisabled) !== null && _ref2 !== void 0 ? _ref2 : isDisabled,
      'aria-describedby': ariaDescribedBy
    });
  }, [children, id, isDisabled, ariaDescribedBy]);
  var Element = labelType === 'legend' ? 'fieldset' : 'div';
  return (0, _react2.jsx)(Element, (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    id: "".concat(id, "-row")
  }, rest), hasLabel ? (0, _react2.jsx)("div", {
    className: "euiFormRow__labelWrapper"
  }, (0, _react2.jsx)(_form_label.EuiFormLabel, (0, _extends2.default)({
    className: "euiFormRow__label",
    "aria-invalid": isInvalid,
    isInvalid: isInvalid,
    isDisabled: isDisabled,
    isFocused: isFocused && !isDisabled,
    id: "".concat(id, "-label")
    // ExclusiveUnion shenanigans
  }, labelType === 'legend' ? {
    type: labelType
  } : {
    type: labelType,
    htmlFor: hasChildLabel ? id : undefined
  }), label), labelAppend && ' ', labelAppend) : hasEmptyLabelSpace && (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m",
    className: "euiFormRow__labelWrapper"
  }), (0, _react2.jsx)("div", {
    className: "euiFormRow__fieldWrapper",
    onFocus: onFocusWithin,
    onBlur: onBlurWithin
  }, field, optionalErrors, optionalHelpTexts));
};
EuiFormRow.propTypes = {
  /**
     * Defaults to rendering a `<label>` but if passed `'legend'` for labelType,
     * will render both a `<legend>` and the surrounding container as a `<fieldset>`
     */
  labelType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["label"]), _propTypes.default.oneOf(["legend"])]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * - `columnCompressed` creates a compressed and horizontal layout
     * - `center`/`centerCompressed` helps align non-input content better with inline form layouts
     * - `rowCompressed` - **deprecated**, does not currently affect styling
     */
  /**
     * - `columnCompressed` creates a compressed and horizontal layout
     * - `center`/`centerCompressed` helps align non-input content better with inline form layouts
     * - `rowCompressed` - **deprecated**, does not currently affect styling
     */
  display: _propTypes.default.any,
  /**
     * Useful for inline form layouts, primarily for content that
     * needs to be aligned with inputs but does not need a label
     */
  /**
     * Useful for inline form layouts, primarily for content that
     * needs to be aligned with inputs but does not need a label
     */
  hasEmptyLabelSpace: _propTypes.default.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  /**
     * IDs of additional elements that should be part of children's `aria-describedby`
     */
  /**
     * IDs of additional elements that should be part of children's `aria-describedby`
     */
  describedByIds: _propTypes.default.arrayOf(_propTypes.default.string.isRequired),
  /**
     * Escape hatch to not render duplicate labels if the child also renders a label
     */
  /**
     * Escape hatch to not render duplicate labels if the child also renders a label
     */
  hasChildLabel: _propTypes.default.bool,
  /**
     * ReactElement to render as this component's content
     */
  /**
     * ReactElement to render as this component's content
     */
  children: _propTypes.default.element.isRequired,
  label: _propTypes.default.node,
  /**
     * Adds an extra node to the right of the form label without
     * being contained inside the form label. Good for things
     * like documentation links.
     */
  /**
     * Adds an extra node to the right of the form label without
     * being contained inside the form label. Good for things
     * like documentation links.
     */
  labelAppend: _propTypes.default.any,
  id: _propTypes.default.string,
  isInvalid: _propTypes.default.bool,
  error: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),
  /**
     *  Adds a single node/string or an array of nodes/strings below the input
     */
  /**
     *  Adds a single node/string or an array of nodes/strings below the input
     */
  helpText: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),
  /**
     *  Passed along to the label element; and to the child field element when `disabled` doesn't already exist on the child field element.
     */
  /**
     *  Passed along to the label element; and to the child field element when `disabled` doesn't already exist on the child field element.
     */
  isDisabled: _propTypes.default.bool
};