"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _radio_group = require("./radio_group");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

var RadioGroup = function RadioGroup() {
  var radioGroupItemId__1 = 'cy-radio-id-1';
  var radioGroupItemId__2 = 'cy-radio-id-2';
  var radioGroupItemId__3 = 'cy-radio-id-3';
  var radioGroupItemId__4 = 'cy-radio-id-4';
  var radios = [{
    id: radioGroupItemId__1,
    label: 'Option one'
  }, {
    id: radioGroupItemId__2,
    label: 'Option two'
  }, {
    id: radioGroupItemId__3,
    label: 'Option three is disabled',
    disabled: true
  }, {
    id: radioGroupItemId__4,
    label: 'Option four'
  }];
  var _useState = (0, _react.useState)(radioGroupItemId__1),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    radioIdSelected = _useState2[0],
    setRadioIdSelected = _useState2[1];
  return (0, _react2.jsx)(_radio_group.EuiRadioGroup, {
    options: radios,
    idSelected: radioIdSelected,
    onChange: function onChange(id) {
      return setRadioIdSelected(id);
    },
    name: "radio group",
    legend: {
      children: (0, _react2.jsx)("span", null, "This is a legend for a radio group")
    }
  });
};
describe('EuiRadioGroup', function () {
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(RadioGroup, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after traversing radio group', function () {
      cy.realPress('Tab');
      cy.get('#cy-radio-id-1').should('have.focus');
      cy.realPress('Space');
      cy.get('#cy-radio-id-1').should('be.checked');
      cy.realPress('ArrowDown');
      cy.get('#cy-radio-id-2').should('be.checked');
      cy.realPress('ArrowRight');
      cy.get('#cy-radio-id-3').should('not.be.checked');
      cy.get('#cy-radio-id-4').should('be.checked');
      cy.checkAxe();
    });
  });
  describe('Disabled radio button accessibility', function () {
    it('affects no change after clicking the disabled radio button', function () {
      cy.get('#cy-radio-id-3').realClick();
      cy.get('#cy-radio-id-3').should('not.be.checked');
      cy.checkAxe();
    });
  });
});