"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeHighlight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _range_highlight = require("./range_highlight.styles");
var _range_levels = require("./range_levels");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiRangeHighlight = exports.EuiRangeHighlight = function EuiRangeHighlight(_ref) {
  var className = _ref.className,
    showTicks = _ref.showTicks,
    trackWidth = _ref.trackWidth,
    lowerValue = _ref.lowerValue,
    upperValue = _ref.upperValue,
    max = _ref.max,
    min = _ref.min,
    background = _ref.background,
    onClick = _ref.onClick,
    levels = _ref.levels;
  // Calculate the width of the range based on value
  var leftPosition = (0, _react.useMemo)(function () {
    return (lowerValue - min) / (max - min);
  }, [lowerValue, min, max]);
  var rangeWidth = (0, _react.useMemo)(function () {
    return (upperValue - lowerValue) / (max - min);
  }, [upperValue, lowerValue, min, max]);
  var classes = (0, _classnames.default)('euiRangeHighlight', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_highlight.euiRangeHighlightStyles)(euiTheme);
  var cssStyles = [styles.euiRangeHighlight, showTicks && styles.hasTicks];
  var progressStyles = (0, _range_highlight.euiRangeHighlightProgressStyles)(euiTheme);
  var cssProgressStyles = [progressStyles.euiRangeHighlight__progress];
  var progressStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      background: background,
      marginLeft: "".concat(leftPosition * 100, "%"),
      width: "".concat(rangeWidth * 100, "%")
    });
  }, [background, leftPosition, rangeWidth]);
  var levelsWrapperStyles = (0, _range_highlight.euiRangeHighlightLevelsWrapperStyles)(euiTheme);
  var cssLevelsWrapperStyles = [levelsWrapperStyles.euiRangeHighlight__levelsWrapper];
  var levelsWrapperStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      marginLeft: "".concat(leftPosition * 100, "%"),
      width: "".concat(rangeWidth * 100, "%")
    });
  }, [leftPosition, rangeWidth]);
  var levelsStyles = (0, _range_highlight.euiRangeHighlightLevelsStyles)(euiTheme);
  var cssLevelsStyles = [levelsStyles.euiRangeHighlight__levels];
  var levelsStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      left: "-".concat(trackWidth * leftPosition, "px"),
      width: "".concat(trackWidth, "px")
    });
  }, [trackWidth, leftPosition]);
  return (0, _react2.jsx)("div", {
    className: classes,
    css: cssStyles,
    onClick: onClick
  }, (levels && levels.length === 0 || !levels) && (0, _react2.jsx)("div", {
    "data-test-subj": "euiRangeHighlightProgress",
    className: "euiRangeHighlight__progress",
    css: cssProgressStyles,
    style: progressStyle
  }), levels && !!levels.length && (0, _react2.jsx)("div", {
    css: cssLevelsWrapperStyles,
    style: levelsWrapperStyle
  }, (0, _react2.jsx)(_range_levels.EuiRangeLevels, {
    css: cssLevelsStyles,
    style: levelsStyle,
    levels: levels,
    max: max,
    min: min,
    showTicks: showTicks,
    trackWidth: trackWidth
  })));
};
EuiRangeHighlight.propTypes = {
  className: _propTypes.default.string,
  background: _propTypes.default.string,
  trackWidth: _propTypes.default.number.isRequired,
  lowerValue: _propTypes.default.number.isRequired,
  upperValue: _propTypes.default.number.isRequired,
  onClick: _propTypes.default.func
};