"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
var _field_number = require("../field_number");
var _range_input = require("./range_input.styles");
var _react2 = require("@emotion/react");
var _excluded = ["min", "max", "step", "value", "inputRef", "isInvalid", "disabled", "compressed", "onChange", "name", "side", "fullWidth", "autoSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiRangeInput = exports.EuiRangeInput = function EuiRangeInput(_ref) {
  var min = _ref.min,
    max = _ref.max,
    step = _ref.step,
    value = _ref.value,
    inputRef = _ref.inputRef,
    isInvalid = _ref.isInvalid,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    onChange = _ref.onChange,
    name = _ref.name,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'max' : _ref$side,
    fullWidth = _ref.fullWidth,
    _ref$autoSize = _ref.autoSize,
    autoSize = _ref$autoSize === void 0 ? true : _ref$autoSize,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_input.euiRangeInputStyles)(euiTheme);
  var cssStyles = [styles.euiRangeInput];

  // Determine whether an invalid icon is showing, which can come from
  // the underlying EuiFieldNumber's native :invalid state
  var _useState = (0, _react.useState)(isInvalid),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    hasInvalidIcon = _useState2[0],
    setHasInvalidIcon = _useState2[1];
  var validityRef = (0, _react.useRef)(null);
  var setRefs = (0, _services.useCombinedRefs)([validityRef, inputRef]);
  (0, _react.useEffect)(function () {
    var _validityRef$current;
    var isNativelyInvalid = !((_validityRef$current = validityRef.current) !== null && _validityRef$current !== void 0 && _validityRef$current.validity.valid);
    setHasInvalidIcon(isNativelyInvalid || isInvalid);
  }, [value, isInvalid]);

  // Calculate the auto size width of the input
  var widthStyle = (0, _react.useMemo)(function () {
    if (!autoSize) return undefined;

    // Calculate the number of characters to show (dynamic based on user input)
    // Uses the min/max char length as a max, then add an extra UX buffer of 1
    var maxChars = Math.max(String(min).length, String(max).length) + 1;
    var inputCharWidth = Math.min(String(value).length, maxChars);

    // Calculate the form padding based on `compressed` state
    var _euiFormVariables = (0, _form.euiFormVariables)(euiTheme),
      controlPadding = _euiFormVariables.controlPadding,
      controlCompressedPadding = _euiFormVariables.controlCompressedPadding;
    var inputPadding = compressed ? controlCompressedPadding : controlPadding;

    // Calculate the invalid icon (if being displayed), also based on `compressed` state
    var invalidIconWidth = hasInvalidIcon ? euiTheme.euiTheme.base * (compressed ? 1.125 : 1.375) // TODO: DRY this out once EuiFormControlLayoutIcons is converted to Emotion
    : 0;

    // Guesstimate a width for the stepper. Note that it's a little wider in FF than it is in Chrome
    var stepperWidth = 2;
    return (0, _global_styling.logicalStyles)({
      width: "calc(".concat(inputPadding, " + ").concat(inputCharWidth, "ch + ").concat(stepperWidth, "em + ").concat(invalidIconWidth, "px)")
    });
  }, [autoSize, euiTheme, compressed, hasInvalidIcon, min, max, value]);
  return (0, _react2.jsx)(_field_number.EuiFieldNumber, (0, _extends2.default)({
    name: name,
    className: "euiRangeInput euiRangeInput--".concat(side),
    css: cssStyles,
    min: Number(min),
    max: Number(max),
    step: step,
    value: value === '' ? '' : Number(value),
    inputRef: setRefs,
    isInvalid: isInvalid,
    disabled: disabled,
    compressed: compressed,
    onChange: onChange,
    style: widthStyle,
    fullWidth: fullWidth
  }, rest));
};
EuiRangeInput.propTypes = {
  autoSize: _propTypes.default.bool,
  /**
     * @default 'max'
     */
  side: _propTypes.default.oneOf(["min", "max"])
};