"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNamedLevelColor = exports.getLevelColor = exports.euiRangeLevelColor = exports.LEVEL_COLORS = void 0;
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var LEVEL_COLORS = exports.LEVEL_COLORS = ['primary', 'success', 'warning', 'danger'];
var isNamedLevelColor = exports.isNamedLevelColor = function isNamedLevelColor(color) {
  return LEVEL_COLORS.includes(color);
};
var euiRangeLevelColor = exports.euiRangeLevelColor = function euiRangeLevelColor(color, euiTheme) {
  return isNamedLevelColor(color) ? euiTheme.colors[color] : color;
};
var getLevelColor = exports.getLevelColor = function getLevelColor(levels, value) {
  var color;
  var _iterator = _createForOfIteratorHelper(levels),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var level = _step.value;
      if (level.min <= value && level.max >= value) {
        color = level.color;
        return color;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return undefined;
};