"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeSlider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _resize_observer = require("../../observer/resize_observer");
var _range_levels_colors = require("./range_levels_colors");
var _range_slider = require("./range_slider.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "disabled", "id", "max", "min", "name", "step", "onChange", "tabIndex", "value", "style", "showTicks", "showRange", "thumbColor", "onResize", "ariaValueText"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiRangeSlider = exports.EuiRangeSlider = function EuiRangeSlider(_ref) {
  var className = _ref.className,
    disabled = _ref.disabled,
    id = _ref.id,
    max = _ref.max,
    min = _ref.min,
    name = _ref.name,
    step = _ref.step,
    onChange = _ref.onChange,
    tabIndex = _ref.tabIndex,
    value = _ref.value,
    style = _ref.style,
    showTicks = _ref.showTicks,
    showRange = _ref.showRange,
    thumbColor = _ref.thumbColor,
    onResize = _ref.onResize,
    ariaValueText = _ref.ariaValueText,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiRangeSlider', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_slider.euiRangeSliderStyles)(euiTheme);
  var thumbStyles = (0, _range_slider.euiRangeSliderThumbStyles)(euiTheme);
  var cssStyles = [styles.euiRangeSlider, showTicks && styles.hasTicks, showRange && styles.hasRange, thumbColor && thumbStyles.thumb];
  var sliderStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)(_objectSpread({
      color: thumbColor && (0, _range_levels_colors.euiRangeLevelColor)(thumbColor, euiTheme.euiTheme)
    }, style));
  }, [thumbColor, euiTheme, style]);
  return (0, _react2.jsx)(_resize_observer.EuiResizeObserver, {
    onResize: onResize
  }, function (resizeRef) {
    return (0, _react2.jsx)("input", (0, _extends2.default)({
      "aria-valuetext": ariaValueText,
      ref: resizeRef,
      type: "range",
      id: id,
      name: name,
      className: classes,
      css: cssStyles,
      min: min,
      max: max,
      step: step,
      value: value,
      disabled: disabled,
      onChange: onChange,
      style: sliderStyle,
      tabIndex: tabIndex
    }, rest));
  });
};
EuiRangeSlider.propTypes = {
  onChange: _propTypes.default.any,
  thumbColor: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  onResize: _propTypes.default.func.isRequired,
  ariaValueText: _propTypes.default.string,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};