"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeTicks = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _inner_text = require("../../inner_text");
var _utils = require("./utils");
var _range_ticks = require("./range_ticks.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiTickValue = function EuiTickValue(_ref) {
  var disabled = _ref.disabled,
    ticks = _ref.ticks,
    min = _ref.min,
    max = _ref.max,
    value = _ref.value,
    onChange = _ref.onChange,
    percentageWidth = _ref.percentageWidth,
    tickValue = _ref.tickValue,
    compressed = _ref.compressed,
    trackWidth = _ref.trackWidth;
  var euiTheme = (0, _services.useEuiTheme)();
  var hasCustomTicks = !!ticks;
  var tickObject = (0, _react.useMemo)(function () {
    return hasCustomTicks ? ticks.find(function (o) {
      return o.value === tickValue;
    }) : {
      value: tickValue,
      label: tickValue
    };
  }, [hasCustomTicks, ticks, tickValue]);
  var isMinTick = (tickObject === null || tickObject === void 0 ? void 0 : tickObject.value) === min;
  var isMaxTick = (tickObject === null || tickObject === void 0 ? void 0 : tickObject.value) === max;
  var label = tickObject ? tickObject.label : tickValue;

  // Math worked out by trial and error
  // Shifts the label into the reserved margin of EuiRangeTrack
  var labelShiftVal = (0, _react.useMemo)(function () {
    return (isMinTick || isMaxTick) && label.length > 3 ? Math.min(label.length * 0.25, 1.25) : 0;
  }, [isMinTick, isMaxTick, label]);
  var tickStyle = (0, _react.useMemo)(function () {
    var styles = {};
    var shift = "-".concat(labelShiftVal, "em");
    if (isMaxTick && labelShiftVal) {
      styles.right = '0%';
      styles.marginRight = shift;
    } else {
      var position = (0, _utils.calculateThumbPosition)(tickValue, min, max, trackWidth);
      var thumbOffset = labelShiftVal ? 0 : _utils.EUI_THUMB_SIZE / 2;
      styles.left = "calc(".concat(position, "% + ").concat(thumbOffset, "px)");
      if (labelShiftVal) styles.marginLeft = shift;
    }
    styles.maxWidth = hasCustomTicks ? undefined : "".concat(percentageWidth, "%");
    return (0, _global_styling.logicalStyles)(styles);
  }, [isMaxTick, labelShiftVal, trackWidth, tickValue, min, max, hasCustomTicks, percentageWidth]);

  // Some ticks need an actual DOM element instead of using a ::before
  var pseudoTick = tickObject && !!labelShiftVal && (isMinTick || isMaxTick);
  var pseudoShift = (0, _react.useMemo)(function () {
    if (!labelShiftVal) return {};
    var marginProperty = isMaxTick ? 'marginRight' : 'marginLeft';
    var tickOffset = euiTheme.euiTheme.size.xs; // xs derived from .euiRangeTicks left/right offset

    return (0, _global_styling.logicalStyles)((0, _defineProperty2.default)({}, marginProperty, "calc(".concat(labelShiftVal, "em + ").concat(tickOffset, ")")));
  }, [labelShiftVal, isMaxTick, euiTheme.euiTheme.size.xs]);
  var styles = (0, _range_ticks.euiRangeTickStyles)(euiTheme);
  var cssTickStyles = [styles.euiRangeTick, value === String(tickValue) && styles.selected, hasCustomTicks && styles.isCustom, labelShiftVal && isMinTick && styles.isMin, labelShiftVal && isMaxTick && styles.isMax, !pseudoTick && styles.hasPseudoTickMark, compressed ? styles.compressed : styles.regular];
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  return (0, _react2.jsx)("button", {
    type: "button",
    className: "euiRangeTick",
    css: cssTickStyles,
    value: tickValue,
    disabled: disabled,
    onClick: onChange,
    style: tickStyle,
    tabIndex: -1,
    ref: ref,
    title: typeof label === 'string' ? label : innerText
  }, pseudoTick && (0, _react2.jsx)("span", {
    className: "euiRangeTick__pseudo",
    css: styles.euiRangeTick__pseudo,
    "aria-hidden": true,
    style: pseudoShift
  }), label);
};
EuiTickValue.propTypes = {
  tickSequence: _propTypes.default.arrayOf(_propTypes.default.number.isRequired).isRequired,
  trackWidth: _propTypes.default.number.isRequired,
  onChange: _propTypes.default.func,
  value: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired, _propTypes.default.any.isRequired]),
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  /**
     * The number to increment or decrement between each interval
     * @default 1
     */
  step: _propTypes.default.number,
  tickValue: _propTypes.default.any.isRequired,
  percentageWidth: _propTypes.default.number.isRequired
};
var EuiRangeTicks = exports.EuiRangeTicks = function EuiRangeTicks(props) {
  var ticks = props.ticks,
    tickSequence = props.tickSequence,
    max = props.max,
    min = props.min,
    _props$tickInterval = props.tickInterval,
    tickInterval = _props$tickInterval === void 0 ? 1 : _props$tickInterval,
    compressed = props.compressed;

  // Calculate the width of each tick mark
  var percentageWidth = (0, _react.useMemo)(function () {
    return tickInterval / (max - min + tickInterval) * 100;
  }, [tickInterval, min, max]);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_ticks.euiRangeTicksStyles)(euiTheme);
  var cssStyles = [styles.euiRangeTicks, compressed ? styles.compressed : styles.regular, ticks && styles.isCustom];
  return (0, _react2.jsx)("div", {
    className: "euiRangeTicks",
    css: cssStyles
  }, tickSequence.map(function (tickValue) {
    return (0, _react2.jsx)(EuiTickValue, (0, _extends2.default)({
      key: tickValue
    }, props, {
      percentageWidth: percentageWidth,
      tickValue: tickValue
    }));
  }));
};
EuiRangeTicks.propTypes = {
  tickSequence: _propTypes.default.arrayOf(_propTypes.default.number.isRequired).isRequired,
  trackWidth: _propTypes.default.number.isRequired,
  onChange: _propTypes.default.func,
  value: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired, _propTypes.default.any.isRequired]),
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  step: _propTypes.default.number
};