"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeTrack = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _range = _interopRequireDefault(require("lodash/range"));
var _services = require("../../../services");
var _range_levels = require("./range_levels");
var _range_ticks = require("./range_ticks");
var _range_track = require("./range_track.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "trackWidth", "disabled", "max", "min", "step", "showTicks", "tickInterval", "ticks", "levels", "onChange", "value", "compressed", "showRange", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiRangeTrack = exports.EuiRangeTrack = function EuiRangeTrack(_ref) {
  var children = _ref.children,
    trackWidth = _ref.trackWidth,
    disabled = _ref.disabled,
    max = _ref.max,
    min = _ref.min,
    step = _ref.step,
    showTicks = _ref.showTicks,
    tickInterval = _ref.tickInterval,
    ticks = _ref.ticks,
    levels = _ref.levels,
    onChange = _ref.onChange,
    value = _ref.value,
    compressed = _ref.compressed,
    showRange = _ref.showRange,
    className = _ref.className,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  (0, _react.useEffect)(function () {
    validateValueIsInStep(max, {
      min: min,
      max: max,
      step: step
    });
  }, [value, min, max, step]);
  var tickSequence = (0, _react.useMemo)(function () {
    if (showTicks !== true) return;
    var sequence;
    if (ticks) {
      // If custom values were passed, use those for the sequence
      // But make sure they align with the possible sequence
      sequence = ticks.map(function (tick) {
        return validateValueIsInStep(tick.value, {
          min: min,
          max: max,
          step: step
        });
      });
    } else {
      // If a custom interval was passed, use those for the sequence
      // But make sure they align with the possible sequence
      var interval = tickInterval || step;

      // Calculate sequence - loop from min to max, creating adding values at each interval
      var sequenceRange = (0, _range.default)(min, max, interval);
      // range is non-inclusive of max, so make it inclusive
      if (max % interval === 0 && !sequenceRange.includes(max)) {
        sequenceRange.push(max);
      }
      sequence = sequenceRange.map(function (tick) {
        return validateValueIsInStep(tick, {
          min: min,
          max: max,
          step: step
        });
      });
    }

    // Error out if there are too many ticks to render
    if (trackWidth && sequence.length) {
      validateTickRenderCount(trackWidth, sequence.length);
    }
    return sequence;
  }, [showTicks, ticks, min, max, tickInterval, step, trackWidth]);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_track.euiRangeTrackStyles)(euiTheme);
  var cssStyles = [styles.euiRangeTrack, disabled && styles.disabled, levels && !!levels.length && styles.hasLevels, showTicks && (tickSequence || ticks) && styles.hasTicks];
  var classes = (0, _classnames.default)('euiRangeTrack', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), levels && !!levels.length && (0, _react2.jsx)(_range_levels.EuiRangeLevels, {
    levels: levels,
    max: max,
    min: min,
    showTicks: showTicks,
    showRange: showRange,
    trackWidth: trackWidth
  }), tickSequence && (0, _react2.jsx)(_range_ticks.EuiRangeTicks, {
    disabled: disabled,
    compressed: compressed,
    onChange: onChange,
    ticks: ticks,
    tickInterval: tickInterval || step,
    tickSequence: tickSequence,
    value: value,
    min: min,
    max: max,
    trackWidth: trackWidth
  }), children);
};
EuiRangeTrack.propTypes = {
  trackWidth: _propTypes.default.number.isRequired,
  onChange: _propTypes.default.func,
  value: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired, _propTypes.default.any.isRequired]),
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  /**
     * The number to increment or decrement between each interval
     * @default 1
     */
  step: _propTypes.default.number,
  /**
     * Specified ticks at specified values
     */
  ticks: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.number.isRequired,
    label: _propTypes.default.node.isRequired,
    accessibleLabel: _propTypes.default.string
  }).isRequired),
  /**
     * Modifies the number of tick marks and at what interval
     */
  tickInterval: _propTypes.default.number,
  /**
     * Create colored indicators for certain intervals.
     * An array of #EuiRangeLevel objects
     */
  levels: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Accepts one of `["primary", "success", "warning", "danger"]` or a valid CSS color value.
       */
    color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired)
};
var validateValueIsInStep = function validateValueIsInStep(value, _ref2) {
  var min = _ref2.min,
    max = _ref2.max,
    step = _ref2.step;
  if (value < min) {
    throw new Error("The value of ".concat(value, " is lower than the min value of ").concat(min, "."));
  }
  if (value > max) {
    throw new Error("The value of ".concat(value, " is higher than the max value of ").concat(max, "."));
  }
  // Error out if the value doesn't line up with the sequence of steps
  if (!(0, _services.isEvenlyDivisibleBy)(value - min, step !== undefined ? step : 1)) {
    throw new Error("The value of ".concat(value, " is not included in the possible sequence provided by the step of ").concat(step, "."));
  }
  // Return the value if nothing fails
  return value;
};
var validateTickRenderCount = function validateTickRenderCount(trackWidth, tickCount) {
  var tickWidth = trackWidth / tickCount;

  // These widths are guesstimations - it's possible we should use actual label content/widths instead
  var COMFORTABLE_TICK_WIDTH = 20; // Set a warning threshold before throwing
  var MIN_TICK_WIDTH = 5; // If ticks are smaller than this, something's gone seriously wrong and we should throw

  var message = "The number of ticks to render (".concat(tickCount, ") is too high for the range width. Ensure all ticks are visible on the page at multiple screen widths, or use EUI's breakpoint hook utilities to reduce the tick interval responsively.");
  if (tickWidth <= MIN_TICK_WIDTH) {
    throw new Error(message);
  } else if (tickWidth < COMFORTABLE_TICK_WIDTH) {
    console.warn(message);
  }
};