"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuperSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _accessibility = require("../../accessibility");
var _popover = require("../../popover");
var _super_select_control = require("./super_select_control");
var _super_select_item = require("./super_select_item");
var _super_select = require("./super_select.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "options", "valueOfSelected", "placeholder", "onChange", "isOpen", "isInvalid", "hasDividers", "itemClassName", "itemLayoutAlign", "fullWidth", "popoverProps", "compressed"],
  _excluded2 = ["value", "dropdownDisplay", "inputDisplay"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var ShiftDirection = /*#__PURE__*/function (ShiftDirection) {
  ShiftDirection["BACK"] = "back";
  ShiftDirection["FORWARD"] = "forward";
  return ShiftDirection;
}(ShiftDirection || {});
var EuiSuperSelect = exports.EuiSuperSelect = /*#__PURE__*/function (_Component) {
  function EuiSuperSelect() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiSuperSelect);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSuperSelect, [].concat(args));
    (0, _defineProperty2.default)(_this, "itemNodes", []);
    (0, _defineProperty2.default)(_this, "_isMounted", false);
    (0, _defineProperty2.default)(_this, "controlButtonRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)(_this, "describedById", (0, _services.htmlIdGenerator)('euiSuperSelect_')('_screenreaderDescribeId'));
    (0, _defineProperty2.default)(_this, "state", {
      isPopoverOpen: _this.props.isOpen || false
    });
    (0, _defineProperty2.default)(_this, "setItemNode", function (node, index) {
      _this.itemNodes[index] = node;
    });
    (0, _defineProperty2.default)(_this, "openPopover", function () {
      _this.setState({
        isPopoverOpen: true
      });
      var focusSelected = function focusSelected() {
        var indexOfSelected = _this.props.options.reduce(function (indexOfSelected, option, index) {
          if (indexOfSelected != null) return indexOfSelected;
          if (option == null) return null;
          return option.value === _this.props.valueOfSelected ? index : null;
        }, null);
        requestAnimationFrame(function () {
          if (!_this._isMounted) {
            return;
          }
          if (_this.props.valueOfSelected != null && indexOfSelected != null) {
            _this.focusItemAt(indexOfSelected);
          } else {
            _this.focusItemAt(0);
          }
          if (_this.props.onFocus) {
            _this.props.onFocus();
          }
        });
      };
      requestAnimationFrame(focusSelected);
    });
    (0, _defineProperty2.default)(_this, "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });

      // Refocus back to the toggling control button on popover close
      requestAnimationFrame(function () {
        var _this$controlButtonRe;
        (_this$controlButtonRe = _this.controlButtonRef.current) === null || _this$controlButtonRe === void 0 || _this$controlButtonRe.focus();
      });
      if (_this.props.onBlur) {
        _this.props.onBlur();
      }
    });
    (0, _defineProperty2.default)(_this, "itemClicked", function (value) {
      _this.closePopover();
      if (_this.props.onChange) {
        _this.props.onChange(value);
      }
    });
    (0, _defineProperty2.default)(_this, "onSelectKeyDown", function (event) {
      // Mimic the ways native `<select>`s can be opened via keypress
      if (event.key === _services.keys.ARROW_UP || event.key === _services.keys.ARROW_DOWN || event.key === _services.keys.SPACE) {
        event.preventDefault();
        event.stopPropagation();
        _this.openPopover();
      }
    });
    (0, _defineProperty2.default)(_this, "onItemKeyDown", function (event) {
      switch (event.key) {
        case _services.keys.ESCAPE:
          // close the popover and prevent ancestors from handling
          event.preventDefault();
          event.stopPropagation();
          _this.closePopover();
          break;
        case _services.keys.TAB:
          // Mimic native `<select>` behavior, which selects an item on tab press
          event.preventDefault();
          event.stopPropagation();
          event.target.click();
          break;
        case _services.keys.ARROW_UP:
          event.preventDefault();
          event.stopPropagation();
          _this.shiftFocus(ShiftDirection.BACK);
          break;
        case _services.keys.ARROW_DOWN:
          event.preventDefault();
          event.stopPropagation();
          _this.shiftFocus(ShiftDirection.FORWARD);
          break;
      }
    });
    return _this;
  }
  (0, _inherits2.default)(EuiSuperSelect, _Component);
  return (0, _createClass2.default)(EuiSuperSelect, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      if (this.props.isOpen) {
        this.openPopover();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "focusItemAt",
    value: function focusItemAt(index, direction) {
      var _targetElement;
      var targetElement = this.itemNodes[index];
      // If the current index is disabled, find the next non-disabled element
      while (targetElement && targetElement.disabled) {
        direction === ShiftDirection.BACK ? index-- : index++;
        targetElement = this.itemNodes[index];
      }
      (_targetElement = targetElement) === null || _targetElement === void 0 || _targetElement.focus();
    }
  }, {
    key: "shiftFocus",
    value: function shiftFocus(direction) {
      var currentIndex = this.itemNodes.indexOf(document.activeElement);
      var targetElementIndex;
      if (currentIndex === -1) {
        // somehow the select options has lost focus
        targetElementIndex = 0;
      } else {
        // Note: this component purposely does not cycle arrow key navigation
        // to match native <select> elements
        if (direction === ShiftDirection.BACK) {
          targetElementIndex = currentIndex - 1;
        } else {
          targetElementIndex = currentIndex + 1;
        }
      }
      this.focusItemAt(targetElementIndex, direction);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        className = _this$props.className,
        options = _this$props.options,
        valueOfSelected = _this$props.valueOfSelected,
        placeholder = _this$props.placeholder,
        onChange = _this$props.onChange,
        isOpen = _this$props.isOpen,
        isInvalid = _this$props.isInvalid,
        hasDividers = _this$props.hasDividers,
        itemClassName = _this$props.itemClassName,
        itemLayoutAlign = _this$props.itemLayoutAlign,
        fullWidth = _this$props.fullWidth,
        popoverProps = _this$props.popoverProps,
        compressed = _this$props.compressed,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var popoverClasses = (0, _classnames.default)('euiSuperSelect', popoverProps === null || popoverProps === void 0 ? void 0 : popoverProps.className);
      var button = (0, _react2.jsx)(_super_select_control.EuiSuperSelectControl, (0, _extends2.default)({
        options: options,
        value: valueOfSelected,
        placeholder: placeholder,
        onClick: this.state.isPopoverOpen ? this.closePopover : this.openPopover,
        onKeyDown: this.onSelectKeyDown,
        className: className,
        fullWidth: fullWidth,
        isInvalid: isInvalid,
        compressed: compressed
      }, rest, {
        buttonRef: this.controlButtonRef,
        isDropdownOpen: this.state.isPopoverOpen
      }));
      var items = options.map(function (option, index) {
        var value = option.value,
          dropdownDisplay = option.dropdownDisplay,
          inputDisplay = option.inputDisplay,
          optionRest = (0, _objectWithoutProperties2.default)(option, _excluded2);
        if (value == null) return;
        return (0, _react2.jsx)(_super_select_item.EuiSuperSelectItem, (0, _extends2.default)({
          key: index,
          id: String(value),
          className: itemClassName,
          hasDividers: hasDividers,
          layoutAlign: itemLayoutAlign,
          icon: valueOfSelected === value ? 'check' : 'empty',
          onClick: function onClick() {
            return _this2.itemClicked(value);
          },
          onKeyDown: _this2.onItemKeyDown,
          buttonRef: function buttonRef(node) {
            return _this2.setItemNode(node, index);
          },
          "aria-selected": valueOfSelected === value
        }, optionRest), dropdownDisplay || inputDisplay);
      });
      return (0, _react2.jsx)(_popover.EuiInputPopover, (0, _extends2.default)({
        closePopover: this.closePopover,
        panelPaddingSize: "none"
      }, popoverProps, {
        className: popoverClasses,
        isOpen: isOpen || this.state.isPopoverOpen,
        input: button,
        fullWidth: fullWidth,
        disableFocusTrap: true // This component handles its own focus manually
      }), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
        id: this.describedById
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiSuperSelect.screenReaderAnnouncement",
        default: "You are in a form selector and must select a single option. Use the Up and Down arrow keys to navigate or Escape to close."
      }))), (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiSuperSelect.ariaLabel",
        default: "Select listbox"
      }, function (ariaLabel) {
        return (0, _react2.jsx)("div", {
          "aria-label": ariaLabel,
          "aria-describedby": _this2.describedById,
          css: _super_select.euiSuperSelectStyles.euiSuperSelect__listbox,
          className: "euiSuperSelect__listbox eui-scrollBar",
          role: "listbox",
          "aria-activedescendant": valueOfSelected != null ? String(valueOfSelected) : undefined,
          tabIndex: 0
        }, items);
      }));
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiSuperSelect, "defaultProps", {
  hasDividers: false,
  fullWidth: false,
  compressed: false,
  isInvalid: false,
  isLoading: false
});
EuiSuperSelect.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  buttonRef: _propTypes.default.any,
  /**
     * @default false
     */
  compressed: _propTypes.default.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  /**
     * @default false
     */
  isInvalid: _propTypes.default.bool,
  /**
     * @default false
     */
  isLoading: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  name: _propTypes.default.string,
  /**
       * Placeholder to display when the current selected value is empty.
       */
  placeholder: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.node]),
  /**
     * Creates an input group with element(s) coming before input.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Creates an input group with element(s) coming after input.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
       * Pass an array of options that must at least include:
       * `value`: storing unique value of item,
       * `inputDisplay`: what shows inside the form input when selected
       * `dropdownDisplay` (optional): what shows for the item in the dropdown
       */
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.any.isRequired,
    inputDisplay: _propTypes.default.node,
    dropdownDisplay: _propTypes.default.node,
    disabled: _propTypes.default.bool,
    "data-test-subj": _propTypes.default.string
  }).isRequired).isRequired,
  valueOfSelected: _propTypes.default.any,
  /**
       * Classes for the context menu item
       */
  itemClassName: _propTypes.default.string,
  /**
       * You must pass an `onChange` function to handle the update of the value
       */
  onChange: _propTypes.default.func,
  onFocus: _propTypes.default.func,
  onBlur: _propTypes.default.func,
  /**
       * Change to `true` if you want horizontal lines between options.
       * This is best used when options are multi-line.
       */
  hasDividers: _propTypes.default.bool,
  /**
       * Change `EuiContextMenuItem` layout position of icon
       */
  itemLayoutAlign: _propTypes.default.oneOf(["center", "top", "bottom"]),
  /**
       * Controls whether the options are shown. Default: false
       */
  isOpen: _propTypes.default.bool,
  /**
       * Optional props to pass to the underlying [EuiInputPopover](/#/layout/popover#popover-attached-to-input-element).
       * Allows fine-grained control of the popover dropdown menu, including
       * `repositionOnScroll` for EuiSuperSelects used within scrollable containers,
       * and customizing popover panel styling.
       *
       * Does not accept a nested `popoverProps.isOpen` property - use the top level
       * `isOpen` API instead.
       */
  popoverProps: _propTypes.default.any
};