"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuperSelectControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _accessibility = require("../../accessibility");
var _form_control_layout = require("../form_control_layout");
var _eui_form_context = require("../eui_form_context");
var _super_select = require("./super_select.styles");
var _react2 = require("@emotion/react");
var _excluded = ["buttonRef", "className", "options", "id", "name", "fullWidth", "isLoading", "isInvalid", "isDropdownOpen", "readOnly", "defaultValue", "compressed", "value", "placeholder", "prepend", "append", "disabled"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiSuperSelectControl = exports.EuiSuperSelectControl = function EuiSuperSelectControl(props) {
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var buttonRef = props.buttonRef,
    className = props.className,
    options = props.options,
    id = props.id,
    name = props.name,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$isLoading = props.isLoading,
    isLoading = _props$isLoading === void 0 ? false : _props$isLoading,
    _props$isInvalid = props.isInvalid,
    isInvalid = _props$isInvalid === void 0 ? false : _props$isInvalid,
    isDropdownOpen = props.isDropdownOpen,
    readOnly = props.readOnly,
    defaultValue = props.defaultValue,
    _props$compressed = props.compressed,
    compressed = _props$compressed === void 0 ? false : _props$compressed,
    value = props.value,
    placeholder = props.placeholder,
    prepend = props.prepend,
    append = props.append,
    disabled = props.disabled,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var classes = (0, _classnames.default)('euiSuperSelectControl', {
    'euiSuperSelectControl-isLoading': isLoading,
    'euiSuperSelectControl-isInvalid': isInvalid
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_super_select.euiSuperSelectControlStyles);
  var cssStyles = [styles.euiSuperSelect__control, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, (prepend || append) && styles.inGroup, isDropdownOpen && styles.open, isInvalid && styles.invalid, readOnly && styles.readOnly, disabled && !readOnly && styles.disabled];
  var inputValue = value != null ? value : defaultValue;
  var selectedValue = (0, _react.useMemo)(function () {
    if (inputValue != null) {
      var selectedOption = options === null || options === void 0 ? void 0 : options.find(function (option) {
        return option.value === inputValue;
      });
      return selectedOption ? selectedOption.inputDisplay : undefined;
    }
  }, [inputValue, options]);
  var showPlaceholder = !!placeholder && !selectedValue;

  // An extra screen reader workaround is required here to make sure `id`s
  // passed from EuiFormRow are inherited by the targetable <button> element
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    formLabelId = _useState2[0],
    setFormLabelId = _useState2[1];
  var hasFormLabel = !!formLabelId;
  (0, _react.useEffect)(function () {
    if (id) {
      var formRowLabel = "".concat(id, "-label");
      var _hasFormLabel = !!document.getElementById(formRowLabel);
      if (_hasFormLabel) {
        setFormLabelId(formRowLabel);
      }
    }
  }, [id]);
  var buttonId = hasFormLabel ? "".concat(id, "-button") : undefined;
  var ariaLabelledBy = hasFormLabel ? "".concat(buttonId, " ").concat(formLabelId) : undefined;
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("input", {
    type: "hidden",
    id: id,
    name: name,
    value: String(inputValue !== null && inputValue !== void 0 ? inputValue : ''),
    readOnly: readOnly
  }), (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, {
    isDropdown: true,
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: disabled,
    readOnly: readOnly,
    compressed: compressed,
    prepend: prepend,
    append: append
  }, (0, _react2.jsx)("button", (0, _extends2.default)({
    type: "button",
    className: classes,
    css: cssStyles,
    "aria-haspopup": "listbox",
    "aria-labelledby": ariaLabelledBy,
    id: buttonId,
    disabled: disabled || readOnly
  }, rest, {
    ref: buttonRef
  }), showPlaceholder ? (0, _react2.jsx)("span", {
    className: "euiSuperSelectControl__placeholder",
    css: styles.euiSuperSelect__placeholder
  }, placeholder) : selectedValue, hasFormLabel &&
  // Add a slight pause between reading out the multiple aria-labelledby elements,
  // mimicking how screen readers handle native <select> elements
  (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, ", ")))));
};