"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _switch = require("./switch");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

var Switch = function Switch() {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    checked = _useState2[0],
    setChecked = _useState2[1];
  return (0, _react2.jsx)(_switch.EuiSwitch, {
    label: "Malware protection",
    checked: checked,
    onChange: function onChange(e) {
      return setChecked(e.target.checked);
    }
  });
};
describe('EuiSwitch', function () {
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(Switch, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('Has zero violations after toggling switch', function () {
      cy.realPress('Tab');
      cy.get('button[role="switch"]').should('have.focus').invoke('attr', 'aria-checked').should('equal', 'false');
      cy.realPress('Enter');
      cy.get('button[role="switch"]').should('have.focus').invoke('attr', 'aria-checked').should('equal', 'true');
      cy.checkAxe();
    });
  });
});