"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightAll = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _escapeRegExp = _interopRequireDefault(require("lodash/escapeRegExp"));
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Internal subcomponent with logic for highlighting all occurrences
 * of a search value within a subject
 *
 * Uses regex rather than indexOf/while loops for easier dev maintainability
 */
var HighlightAll = exports.HighlightAll = function HighlightAll(_ref) {
  var searchSubject = _ref.searchSubject,
    _searchValue = _ref.searchValue,
    isStrict = _ref.isStrict,
    _ref$highlightCompone = _ref.highlightComponent,
    HighlightComponent = _ref$highlightCompone === void 0 ? 'mark' : _ref$highlightCompone;
  var searchValue = (0, _react.useMemo)(function () {
    return Array.isArray(_searchValue) ? _searchValue.map(_escapeRegExp.default).join('|') : (0, _escapeRegExp.default)(_searchValue);
  }, [_searchValue]);
  var chunks = (0, _react.useMemo)(function () {
    var regex = new RegExp(searchValue, isStrict ? 'g' : 'gi');
    var matches = (0, _toConsumableArray2.default)(searchSubject.matchAll(regex)).map(function (match) {
      return {
        start: match.index || 0,
        end: (match.index || 0) + match[0].length
      };
    });
    return fillInChunks(matches, searchSubject.length);
  }, [searchValue, searchSubject, isStrict]);
  return (0, _react2.jsx)(_react.default.Fragment, null, chunks.map(function (chunk) {
    var end = chunk.end,
      highlight = chunk.highlight,
      start = chunk.start;
    var value = searchSubject.substring(start, end);
    return highlight ? (0, _react2.jsx)(HighlightComponent, {
      key: start
    }, value) : value;
  }));
};

/**
 * Chunk utility
 */
HighlightAll.propTypes = {
  searchValue: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired]).isRequired,
  searchSubject: _propTypes.default.string.isRequired,
  isStrict: _propTypes.default.bool.isRequired,
  highlightComponent: _propTypes.default.any
};
var fillInChunks = function fillInChunks(chunksToHighlight, totalLength) {
  var allChunks = [];
  var append = function append(start, end, highlight) {
    if (end - start > 0) {
      allChunks.push({
        start: start,
        end: end,
        highlight: highlight
      });
    }
  };
  if (chunksToHighlight.length === 0) {
    append(0, totalLength, false);
  } else {
    var lastIndex = 0;
    chunksToHighlight.forEach(function (chunk) {
      append(lastIndex, chunk.start, false);
      append(chunk.start, chunk.end, true);
      lastIndex = chunk.end;
    });
    append(lastIndex, totalLength, false);
  }
  return allChunks;
};