"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.MARGINS = exports.EuiHorizontalRule = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _horizontal_rule = require("./horizontal_rule.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "size", "margin"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var SIZES = exports.SIZES = ['full', 'half', 'quarter'];
var MARGINS = exports.MARGINS = ['none', 'xs', 's', 'm', 'l', 'xl', 'xxl'];
var EuiHorizontalRule = exports.EuiHorizontalRule = function EuiHorizontalRule(_ref) {
  var className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'full' : _ref$size,
    _ref$margin = _ref.margin,
    margin = _ref$margin === void 0 ? 'l' : _ref$margin,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiHorizontalRule', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_horizontal_rule.euiHorizontalRuleStyles);
  var cssStyles = [styles.euiHorizontalRule, styles[size], styles[margin]];
  return (0, _react2.jsx)("hr", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest));
};
EuiHorizontalRule.propTypes = {
  /**
     * Defines the width of the HR.
     */
  size: _propTypes.default.any,
  margin: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};