"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _image_wrapper = require("./image_wrapper");
var _image = require("./image.styles");
var _image_fullscreen_wrapper = require("./image_fullscreen_wrapper");
var _image_types = require("./image_types");
var _react2 = require("@emotion/react");
var _excluded = ["className", "alt", "url", "src", "size", "hasShadow", "style", "wrapperProps", "fullScreenIconColor", "allowFullScreen", "caption", "float", "margin", "onFullScreen"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiImage = exports.EuiImage = function EuiImage(_ref) {
  var className = _ref.className,
    alt = _ref.alt,
    url = _ref.url,
    src = _ref.src,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'original' : _ref$size,
    hasShadow = _ref.hasShadow,
    style = _ref.style,
    wrapperProps = _ref.wrapperProps,
    fullScreenIconColor = _ref.fullScreenIconColor,
    allowFullScreen = _ref.allowFullScreen,
    caption = _ref.caption,
    float = _ref.float,
    margin = _ref.margin,
    onFullScreen = _ref.onFullScreen,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isFullScreen = _useState2[0],
    setIsFullScreen = _useState2[1];
  var isNamedSize = typeof size === 'string' && _image_types.SIZES.includes(size);
  var classes = (0, _classnames.default)('euiImage', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _image.euiImageStyles)(euiTheme);
  var cssStyles = [styles.euiImage, isNamedSize && styles[size], !isNamedSize && styles.customSize, hasShadow && styles.hasShadow];
  var cssIsFullScreenStyles = [styles.euiImage, styles.isFullScreen];
  var isCustomSize = !isNamedSize && size !== 'original';
  var customSize = typeof size === 'string' ? size : "".concat(size, "px");
  var imageStyleWithCustomSize = isCustomSize ? _objectSpread(_objectSpread({}, style), {}, {
    maxWidth: customSize,
    maxHeight: customSize
  }) : style;
  var isFullWidth = size === 'fullWidth';
  var commonWrapperProps = {
    hasShadow: hasShadow,
    wrapperProps: wrapperProps,
    setIsFullScreen: setIsFullScreen,
    fullScreenIconColor: fullScreenIconColor,
    isFullWidth: isFullWidth,
    allowFullScreen: allowFullScreen,
    alt: alt,
    caption: caption,
    float: float,
    margin: margin,
    onFullScreen: onFullScreen
  };
  var commonImgProps = _objectSpread({
    className: classes,
    src: src || url
  }, rest);
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_image_wrapper.EuiImageWrapper, commonWrapperProps, (0, _react2.jsx)("img", (0, _extends2.default)({
    alt: alt,
    css: cssStyles,
    style: imageStyleWithCustomSize
  }, commonImgProps))), allowFullScreen && isFullScreen && (0, _react2.jsx)(_image_fullscreen_wrapper.EuiImageFullScreenWrapper, commonWrapperProps, (0, _react2.jsx)("img", (0, _extends2.default)({
    alt: alt,
    css: cssIsFullScreenStyles,
    style: style
  }, commonImgProps))));
};
EuiImage.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Requires either `src` or `url` but defaults to using `src` if both are provided
       */
  src: _propTypes.default.string,
  url: _propTypes.default.string,
  /**
       * Alt text should describe the image to aid screen reader users. See
       * https://webaim.org/techniques/alttext/ for a guide on writing
       * effective alt text.
       *
       * If no meaningful description exists, or if the image is adequately
       * described by the surrounding text, pass an empty string.
       */
  alt: _propTypes.default.string.isRequired,
  /**
       * Provides a visible caption to the image
       */
  caption: _propTypes.default.node,
  /**
       * Accepts `s` / `m` / `l` / `xl` / `original` / `fullWidth` / or a CSS size of `number` or `string`.
       * `fullWidth` will set the figure to stretch to 100% of its container.
       * `string` and `number` types will max both the width or height, whichever is greater.
       */
  size: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
       * Float the image to the left or right. Useful in large text blocks.
       */
  float: _propTypes.default.any,
  /**
       * Margin around the image.
       */
  margin: _propTypes.default.any,
  /**
       * When set to `true` (default) will apply a slight shadow to the image
       */
  hasShadow: _propTypes.default.bool,
  /**
       * When set to `true` will make the image clickable to a larger version
       */
  allowFullScreen: _propTypes.default.bool,
  /**
       * Callback when the image is clicked and `allowFullScreen` is `true`
       */
  onFullScreen: _propTypes.default.func,
  /**
       * Changes the color of the icon that floats above the image when it can be clicked to fullscreen.
       * The default value of `light` is fine unless your image has a white background, in which case you should change it to `dark`.
       */
  fullScreenIconColor: _propTypes.default.oneOf(["light", "dark"]),
  /**
       * Props to add to the wrapping figure element
       */
  wrapperProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  })
};