"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _image_wrapper = require("./image_wrapper.styles");
var _image_button = require("./image_button");
var _image_caption = require("./image_caption");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiImageWrapper = exports.EuiImageWrapper = function EuiImageWrapper(_ref) {
  var alt = _ref.alt,
    caption = _ref.caption,
    hasShadow = _ref.hasShadow,
    allowFullScreen = _ref.allowFullScreen,
    float = _ref.float,
    margin = _ref.margin,
    children = _ref.children,
    setIsFullScreen = _ref.setIsFullScreen,
    wrapperProps = _ref.wrapperProps,
    fullScreenIconColor = _ref.fullScreenIconColor,
    isFullWidth = _ref.isFullWidth,
    onFullScreen = _ref.onFullScreen;
  var openFullScreen = function openFullScreen() {
    setIsFullScreen(true);
    onFullScreen === null || onFullScreen === void 0 || onFullScreen(true);
  };
  var classes = (0, _classnames.default)('euiImageWrapper', wrapperProps && wrapperProps.className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _image_wrapper.euiImageWrapperStyles)(euiTheme);
  var cssFigureStyles = [styles.euiImageWrapper, float && styles[float], margin && styles[margin], allowFullScreen && styles.allowFullScreen, isFullWidth && styles.fullWidth, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
    optionalCaptionRef = _useInnerText2[0],
    optionalCaptionText = _useInnerText2[1];
  return (0, _react2.jsx)("figure", (0, _extends2.default)({
    "aria-label": optionalCaptionText
  }, wrapperProps, {
    className: classes,
    css: cssFigureStyles
  }), allowFullScreen ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_image_button.EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: openFullScreen,
    "data-test-subj": "activateFullScreenButton",
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children)) : children, (0, _react2.jsx)(_image_caption.EuiImageCaption, {
    ref: optionalCaptionRef,
    caption: caption
  }));
};
EuiImageWrapper.propTypes = {
  isFullWidth: _propTypes.default.bool.isRequired,
  setIsFullScreen: _propTypes.default.func.isRequired
};