"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingElastic = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../icon");
var _loading_strings = require("./_loading_strings");
var _loading_elastic = require("./loading_elastic.styles");
var _react2 = require("@emotion/react");
var _excluded = ["size", "className", "aria-label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var SIZES = exports.SIZES = ['m', 'l', 'xl', 'xxl'];
var EuiLoadingElastic = exports.EuiLoadingElastic = function EuiLoadingElastic(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    ariaLabel = _ref['aria-label'],
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiLoadingElastic', className);
  var defaultLabel = (0, _loading_strings.useLoadingAriaLabel)();
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: _loading_elastic.euiLoadingElasticStyles.euiLoadingElastic,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "logoElastic",
    size: size
  }));
};
EuiLoadingElastic.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  size: _propTypes.default.any
};