"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckboxMarkdownRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
var _checkbox = require("../../../form/checkbox");
var _markdown_context = require("../../markdown_context");
var _accessibility = require("../../../../services/accessibility");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var CheckboxMarkdownRenderer = exports.CheckboxMarkdownRenderer = function CheckboxMarkdownRenderer(_ref) {
  var position = _ref.position,
    lead = _ref.lead,
    label = _ref.label,
    isChecked = _ref.isChecked,
    children = _ref.children;
  var _useContext = (0, _react.useContext)(_markdown_context.EuiMarkdownContext),
    replaceNode = _useContext.replaceNode,
    readOnly = _useContext.readOnly;
  return (0, _react2.jsx)(_checkbox.EuiCheckbox, {
    id: (0, _accessibility.useGeneratedHtmlId)(),
    checked: isChecked,
    label: children,
    onChange: function onChange() {
      replaceNode(position, "".concat(lead, "[").concat(isChecked ? ' ' : 'x', "]").concat(label));
    },
    css: markdownCheckboxStyles,
    readOnly: readOnly
  });
};
CheckboxMarkdownRenderer.propTypes = {
  type: _propTypes.default.oneOf(["checkboxPlugin"]).isRequired,
  lead: _propTypes.default.string.isRequired,
  label: _propTypes.default.string.isRequired,
  isChecked: _propTypes.default.bool.isRequired,
  position: _propTypes.default.shape({
    start: _propTypes.default.shape({
      line: _propTypes.default.number.isRequired,
      column: _propTypes.default.number.isRequired,
      offset: _propTypes.default.number.isRequired
    }).isRequired,
    end: _propTypes.default.shape({
      line: _propTypes.default.number.isRequired,
      column: _propTypes.default.number.isRequired,
      offset: _propTypes.default.number.isRequired
    }).isRequired
  }).isRequired
};
var markdownCheckboxStyles = /*#__PURE__*/(0, _react2.css)("&&{.euiCheckbox__input~.euiCheckbox__label{font-size:inherit;line-height:inherit;", (0, _global_styling.logicalCSS)('padding-left', '1.5em'), ";}&:has(+ :not(.euiCheckbox)){", (0, _global_styling.logicalCSS)('margin-bottom', '1em'), ";}.euiCheckbox__input+.euiCheckbox__square{", (0, _global_styling.logicalCSS)('top', '50%'), " transform:translateY(-50%);}};label:markdownCheckboxStyles;");