"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultEuiMarkdownPlugins = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ui_plugins = require("./ui_plugins");
var _parsing_plugins = require("./parsing_plugins");
var _processing_plugins = require("./processing_plugins");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var getDefaultEuiMarkdownPlugins = exports.getDefaultEuiMarkdownPlugins = function getDefaultEuiMarkdownPlugins() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var exclude = config.exclude,
    processingConfig = config.processingConfig,
    parsingConfig = config.parsingConfig,
    uiConfig = config.uiConfig;
  return {
    parsingPlugins: (0, _parsing_plugins.getDefaultEuiMarkdownParsingPlugins)(_objectSpread({
      exclude: exclude
    }, parsingConfig)),
    processingPlugins: (0, _processing_plugins.getDefaultEuiMarkdownProcessingPlugins)(_objectSpread({
      exclude: exclude
    }, processingConfig)),
    uiPlugins: (0, _ui_plugins.getDefaultEuiMarkdownUiPlugins)(_objectSpread({
      exclude: exclude
    }, uiConfig))
  };
};