"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultEuiMarkdownProcessingPlugins = exports.defaultProcessingPlugins = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _all = _interopRequireDefault(require("mdast-util-to-hast/lib/all"));
var _rehypeReact = _interopRequireDefault(require("rehype-react"));
var _remarkRehype = _interopRequireDefault(require("remark-rehype"));
var _link = require("../../../link");
var _code = require("../../../code");
var _horizontal_rule = require("../../../horizontal_rule");
var _remark_prismjs = require("../remark/remark_prismjs");
var MarkdownTooltip = _interopRequireWildcard(require("../markdown_tooltip"));
var MarkdownCheckbox = _interopRequireWildcard(require("../markdown_checkbox"));
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // Importing seemingly unused types from `unified` because the definitions
// are exported for two versions of TypeScript (3.4, 4.0) and implicit
// imports during eui.d.ts generation default to the incorrect version (3.4).
// Explicit imports here resolve the version mismatch.
var unknownHandler = function unknownHandler(h, node) {
  return h(node, node.type, node, (0, _all.default)(h, node));
};
var DEFAULT_COMPONENT_RENDERERS = {
  checkbox: MarkdownCheckbox.renderer,
  tooltip: MarkdownTooltip.renderer
};
var getDefaultEuiMarkdownProcessingPlugins = exports.getDefaultEuiMarkdownProcessingPlugins = function getDefaultEuiMarkdownProcessingPlugins() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    exclude = _ref.exclude,
    linkProps = _ref.linkProps;
  var componentPluginsWithExclusions = {};
  Object.entries(DEFAULT_COMPONENT_RENDERERS).forEach(function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
      excludeName = _ref3[0],
      renderer = _ref3[1];
    if (!(exclude !== null && exclude !== void 0 && exclude.includes(excludeName))) {
      var pluginName = "".concat(excludeName, "Plugin");
      componentPluginsWithExclusions[pluginName] = renderer;
    }
  });
  var plugins = [[_remarkRehype.default, {
    allowDangerousHtml: true,
    unknownHandler: unknownHandler,
    handlers: {} // intentionally empty, allows plugins to extend if they need to
  }], [_rehypeReact.default, {
    createElement: _react.createElement,
    Fragment: _react.Fragment,
    components: _objectSpread({
      a: function a(props) {
        return (0, _react2.jsx)(_link.EuiLink, (0, _extends2.default)({}, props, linkProps));
      },
      code: function code(props) {
        return (
          // If there are linebreaks use codeblock, otherwise code
          /\r|\n/.exec(props.children) || props.className && props.className.indexOf(_remark_prismjs.FENCED_CLASS) > -1 ? (0, _react2.jsx)(_code.EuiCodeBlock, (0, _extends2.default)({
            fontSize: "m",
            paddingSize: "s",
            isCopyable: true
          }, props)) : (0, _react2.jsx)(_code.EuiCode, props)
        );
      },
      // When we use block code "fences" the code tag is replaced by the `EuiCodeBlock`.
      // But there's a `pre` tag wrapping all the `EuiCodeBlock`.
      // We want to replace this `pre` tag with a `div` because the `EuiCodeBlock` has its own children `pre` tag.
      pre: function pre(props) {
        return (0, _react2.jsx)("div", (0, _extends2.default)({}, props, {
          className: "euiMarkdownFormat__codeblockWrapper"
        }));
      },
      blockquote: function blockquote(props) {
        return (0, _react2.jsx)("blockquote", (0, _extends2.default)({}, props, {
          className: "euiMarkdownFormat__blockquote"
        }));
      },
      table: function table(props) {
        return (0, _react2.jsx)("table", (0, _extends2.default)({
          className: "euiMarkdownFormat__table"
        }, props));
      },
      hr: function hr(props) {
        return (0, _react2.jsx)(_horizontal_rule.EuiHorizontalRule, props);
      }
    }, componentPluginsWithExclusions)
  }]];
  return plugins;
};
var defaultProcessingPlugins = exports.defaultProcessingPlugins = getDefaultEuiMarkdownProcessingPlugins();