"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tooltipMarkdownRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tool_tip = require("../../../tool_tip");
var _icon = require("../../../icon");
var _react2 = require("@emotion/react");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "blrk0m-tooltipMarkdownRenderer",
  styles: "transform:translateY(-1px);label:tooltipMarkdownRenderer;"
} : {
  name: "blrk0m-tooltipMarkdownRenderer",
  styles: "transform:translateY(-1px);label:tooltipMarkdownRenderer;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var tooltipMarkdownRenderer = exports.tooltipMarkdownRenderer = function tooltipMarkdownRenderer(_ref) {
  var content = _ref.content,
    children = _ref.children;
  return (0, _react2.jsx)("span", null, (0, _react2.jsx)(_tool_tip.EuiToolTip, {
    content: content
  }, (0, _react2.jsx)("span", null, (0, _react2.jsx)("strong", null, children), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "questionInCircle"
    // This is to offset the tooltip icon, which isn't perfectly centered
    ,
    css: _ref2
  }))));
};
tooltipMarkdownRenderer.propTypes = {
  type: _propTypes.default.oneOf(["tooltipPlugin"]).isRequired,
  content: _propTypes.default.string.isRequired,
  position: _propTypes.default.shape({
    start: _propTypes.default.shape({
      line: _propTypes.default.number.isRequired,
      column: _propTypes.default.number.isRequired,
      offset: _propTypes.default.number.isRequired
    }).isRequired,
    end: _propTypes.default.shape({
      line: _propTypes.default.number.isRequired,
      column: _propTypes.default.number.isRequired,
      offset: _propTypes.default.number.isRequired
    }).isRequired
  }).isRequired
};