"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiModalBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _modal_body = require("./modal_body.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiModalBody = exports.EuiModalBody = function EuiModalBody(_ref) {
  var className = _ref.className,
    children = _ref.children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiModalBody', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _modal_body.euiModalBodyStyles)(euiTheme);
  var cssStyles = [styles.euiModalBody];
  var cssOverflowStyles = [styles.euiModalBody__overflow];
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), (0, _react2.jsx)("div", {
    css: cssOverflowStyles,
    className: "euiModalBody__overflow"
  }, children));
};
EuiModalBody.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};