"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMutationObserver = exports.EuiMutationObserver = void 0;
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
var _observer = require("../observer");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiMutationObserver = exports.EuiMutationObserver = /*#__PURE__*/function (_EuiObserver) {
  function EuiMutationObserver() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiMutationObserver);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiMutationObserver, [].concat(args));
    (0, _defineProperty2.default)(_this, "name", 'EuiMutationObserver');
    // the `onMutation` prop may change while the observer is bound, abstracting
    // it out into a separate function means the current `onMutation` value is used
    (0, _defineProperty2.default)(_this, "onMutation", function (records, observer) {
      _this.props.onMutation(records, observer);
    });
    (0, _defineProperty2.default)(_this, "beginObserve", function () {
      var childNode = _this.childNode;
      _this.observer = makeMutationObserver(childNode, _this.props.observerOptions, _this.onMutation);
    });
    return _this;
  }
  (0, _inherits2.default)(EuiMutationObserver, _EuiObserver);
  return (0, _createClass2.default)(EuiMutationObserver);
}(_observer.EuiObserver);
var makeMutationObserver = function makeMutationObserver(node, _observerOptions, callback) {
  // The MutationObserver polyfill used in Kibana (for Jest) implements
  // an older spec in which specifying `attributeOldValue` or `attributeFilter`
  // without specifying `attributes` results in a `SyntaxError`.
  // The following logic patches the newer spec in which `attributes: true` can be
  // implied when appropriate (`attributeOldValue` or `attributeFilter` is specified).
  var observerOptions = _objectSpread({}, _observerOptions);
  var needsAttributes = observerOptions.hasOwnProperty('attributeOldValue') || observerOptions.hasOwnProperty('attributeFilter');
  if (needsAttributes && !observerOptions.hasOwnProperty('attributes')) {
    observerOptions.attributes = true;
  }
  var observer = new MutationObserver(callback);
  observer.observe(node, observerOptions);
  return observer;
};
var useMutationObserver = exports.useMutationObserver = function useMutationObserver(container, callback, observerOptions) {
  (0, _react.useEffect)(function () {
    if (container != null) {
      var observer = makeMutationObserver(container, observerOptions, callback);
      return function () {
        return observer.disconnect();
      };
    }
  },
  // ignore changing observerOptions
  // eslint-disable-next-line
  [container, callback]);
};