"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiObserver = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiObserver = exports.EuiObserver = /*#__PURE__*/function (_Component) {
  function EuiObserver() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiObserver);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiObserver, [].concat(args));
    (0, _defineProperty2.default)(_this, "name", 'EuiObserver');
    (0, _defineProperty2.default)(_this, "childNode", null);
    (0, _defineProperty2.default)(_this, "observer", null);
    (0, _defineProperty2.default)(_this, "updateChildNode", function (ref) {
      if (_this.childNode === ref) return; // node hasn't changed

      // if there's an existing observer disconnect it
      if (_this.observer != null) {
        _this.observer.disconnect();
        _this.observer = null;
      }
      _this.childNode = ref;
      if (_this.childNode != null) {
        _this.beginObserve();
      }
    });
    (0, _defineProperty2.default)(_this, "beginObserve", function () {
      throw new Error('EuiObserver has no default observation method');
    });
    return _this;
  }
  (0, _inherits2.default)(EuiObserver, _Component);
  return (0, _createClass2.default)(EuiObserver, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.childNode == null) {
        throw new Error("".concat(this.name, " did not receive a ref"));
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.observer != null) {
        this.observer.disconnect();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var props = this.props;
      return props.children(this.updateChildNode);
    }
  }]);
}(_react.Component);