"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResizeObserver = exports.hasResizeObserver = exports.EuiResizeObserver = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Re-export `hasResizeObserver` as-is
var hasResizeObserver = exports.hasResizeObserver = typeof window !== 'undefined' && typeof window.ResizeObserver !== 'undefined';

/**
 * jsdom currently does not support ResizeObservers (@see https://github.com/jsdom/jsdom/issues/3368)
 * To mimic RO init behavior (should call onResize on mount), we're providing the below testenv mocks.
 */

var EuiResizeObserver = exports.EuiResizeObserver = function EuiResizeObserver(_ref) {
  var onResize = _ref.onResize,
    children = _ref.children;
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    observedElement = _useState2[0],
    setObservedElement = _useState2[1];
  (0, _react.useEffect)(function () {
    if (observedElement) {
      var _observedElement$getB = observedElement.getBoundingClientRect(),
        width = _observedElement$getB.width,
        height = _observedElement$getB.height;
      onResize({
        width: width,
        height: height
      });
    }
  }, [observedElement, onResize]);
  return children(setObservedElement);
};
var useResizeObserver = exports.useResizeObserver = function useResizeObserver(container, dimension) {
  var _useState3 = (0, _react.useState)({
      width: 0,
      height: 0
    }),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    size = _useState4[0],
    setSize = _useState4[1];
  (0, _react.useEffect)(function () {
    if (container != null) {
      var _container$getBoundin = container.getBoundingClientRect(),
        width = _container$getBoundin.width,
        height = _container$getBoundin.height;
      setSize({
        width: width,
        height: height
      });
    }
  }, [container, dimension]);
  return size;
};