"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGE_MAX_WIDTH = void 0;
exports.setPropsForRestrictedPageWidth = setPropsForRestrictedPageWidth;
exports.setStyleForRestrictedPageWidth = setStyleForRestrictedPageWidth;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The `restrictedWidth` property is the same for all EuiPage components.
 * This is file contains the type specific to that prop and a helper
 * function for creating the corresponding classNames and style tags
 * based on the consumer's configuration
 */

// TODO: Decide how to make this a global value but still isolated to the page component
var PAGE_MAX_WIDTH = exports.PAGE_MAX_WIDTH = '1200px';
/**
 * **DEPRECATED**
 * This function calculates the correct class name and combined styles
 * based on the `restrictWidth` value passed in
 *
 * @param restrictWidth `boolean | number | string` The prop value
 * @param style `CSSProperties` An object of style attributes if provided
 * @returns An object with keys for the `widthClassName` to append to the component's class and the updated `newStyle` props
 */
function setPropsForRestrictedPageWidth(restrictWidth, style) {
  var widthClassName;
  var newStyle = _objectSpread({}, style);
  if (restrictWidth === true) {
    widthClassName = 'restrictWidth-default';
  } else if (restrictWidth !== false) {
    widthClassName = 'restrictWidth-custom';
    newStyle.maxWidth = restrictWidth;
  }
  return {
    widthClassName: widthClassName,
    newStyle: newStyle
  };
}

/**
 * This function calculates the correct just the combined styles
 * based on the `restrictWidth` value passed in
 *
 * @param restrictWidth `boolean | number | string` The prop value
 * @param style `CSSProperties` An object of style attributes if provided
 * @returns An object of the updated `style` props
 */
function setStyleForRestrictedPageWidth(restrictWidth, style) {
  var newStyle = _objectSpread({}, style);
  if (restrictWidth === true) {
    newStyle.maxWidth = PAGE_MAX_WIDTH;
  } else if (restrictWidth !== false) {
    newStyle.maxWidth = restrictWidth;
  }
  return newStyle;
}