"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiSplitPanelOuter = exports._EuiSplitPanelInner = exports.EuiSplitPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _breakpoint = require("../../../services/breakpoint");
var _panel = require("../panel");
var _split_panel = require("./split_panel.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className"],
  _excluded2 = ["children", "className", "direction", "responsive"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Consumed via `EuiSplitPanel.Inner`.
 * Extends most `EuiPanelProps`.
 */
var _EuiSplitPanelInner = exports._EuiSplitPanelInner = function _EuiSplitPanelInner(_ref) {
  var children = _ref.children,
    className = _ref.className,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSplitPanel__inner', className);
  var panelProps = {
    hasShadow: false,
    color: 'transparent',
    borderRadius: 'none',
    hasBorder: false
  };
  return (0, _react2.jsx)(_panel.EuiPanel, (0, _extends2.default)({
    element: "div",
    className: classes,
    css: _split_panel.euiSplitPanelInnerStyles.euiSplitPanelInner
  }, panelProps, rest), children);
};
_EuiSplitPanelInner.propTypes = {
  /**
     * Padding for all four sides
     */
  paddingSize: _propTypes.default.any,
  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */
  grow: _propTypes.default.bool,
  panelRef: _propTypes.default.any,
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
/**
 * Consumed via `EuiSplitPanel.Outer`.
 * Extends most `EuiPanelProps`.
 */
var _EuiSplitPanelOuter = exports._EuiSplitPanelOuter = function _EuiSplitPanelOuter(_ref2) {
  var children = _ref2.children,
    className = _ref2.className,
    _ref2$direction = _ref2.direction,
    direction = _ref2$direction === void 0 ? 'column' : _ref2$direction,
    _ref2$responsive = _ref2.responsive,
    responsive = _ref2$responsive === void 0 ? ['xs', 's'] : _ref2$responsive,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var isResponsive = (0, _breakpoint.useIsWithinBreakpoints)(responsive, !!responsive);
  var styles = _split_panel.euiSplitPanelOuterStyles;
  var cssStyles = [styles.euiSplitPanelOuter, direction === 'row' && !isResponsive ? styles.row : styles.column];
  var classes = (0, _classnames.default)('euiSplitPanel', className);
  return (0, _react2.jsx)(_panel.EuiPanel, (0, _extends2.default)({
    paddingSize: "none",
    grow: false,
    className: classes,
    css: cssStyles
  }, rest), children);
};
_EuiSplitPanelOuter.propTypes = {
  /**
     * Any number of _EuiSplitPanelInner components
     */
  children: _propTypes.default.node,
  /**
     * Changes the flex-direction
     */
  direction: _propTypes.default.oneOf(["column", "row"]),
  /**
     * Stacks row display on small screens.
     * Remove completely with `false` or provide your own list of breakpoint sizes to stack on.
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.oneOf([false]), _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired])
};
var EuiSplitPanel = exports.EuiSplitPanel = {
  Outer: _EuiSplitPanelOuter,
  Inner: _EuiSplitPanelInner
};