"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPopoverPanelContext = exports.EuiPopoverPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _panel = require("../../panel/panel");
var _popover_panel = require("./_popover_panel.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "isOpen", "isAttached", "position"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var DEFAULT_PANEL_PADDING_SIZE = 'l';
var EuiPopoverPanelContext = exports.EuiPopoverPanelContext = /*#__PURE__*/(0, _react.createContext)({
  paddingSize: DEFAULT_PANEL_PADDING_SIZE
});
/**
 * *INTERNAL ONLY*
 * Purely for re-use of styling
 */
var EuiPopoverPanel = exports.EuiPopoverPanel = function EuiPopoverPanel(_ref) {
  var children = _ref.children,
    className = _ref.className,
    isOpen = _ref.isOpen,
    isAttached = _ref.isAttached,
    position = _ref.position,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiPopover__panel', className);
  var euiThemeContext = (0, _services.useEuiTheme)();
  var cssStyles = (0, _react.useMemo)(function () {
    var styles = (0, _popover_panel.euiPopoverPanelStyles)(euiThemeContext);
    var colorMode = euiThemeContext.colorMode.toLowerCase();
    var sharedStyles = [styles.euiPopover__panel, styles[colorMode], isOpen && styles.isOpen];
    if (isAttached) {
      return [].concat(sharedStyles, [styles.isAttached.isAttached, position && styles.isAttached[position]]);
    }
    return [].concat(sharedStyles, [styles.hasTransform.hasTransform, isOpen && position && styles.hasTransform[position]]);
  }, [euiThemeContext, isOpen, position, isAttached]);
  return (0, _react2.jsx)(EuiPopoverPanelContext.Provider, {
    value: {
      paddingSize: rest.paddingSize || DEFAULT_PANEL_PADDING_SIZE
    }
  }, (0, _react2.jsx)(_panel.EuiPanel, (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    "data-popover-panel": true,
    "data-popover-open": isOpen || undefined
  }, rest), children));
};
EuiPopoverPanel.propTypes = {
  isOpen: _propTypes.default.bool,
  isAttached: _propTypes.default.bool,
  position: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([null])])
};