"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPopoverTitle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _popover_title = require("./popover_title.styles");
var _popover_panel = require("./popover_panel/_popover_panel");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "paddingSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiPopoverTitle = exports.EuiPopoverTitle = function EuiPopoverTitle(_ref) {
  var children = _ref.children,
    className = _ref.className,
    paddingSize = _ref.paddingSize,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_popover_panel.EuiPopoverPanelContext),
    panelPadding = _useContext.paddingSize;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _popover_title.euiPopoverTitleStyles)(euiTheme);
  var paddingStyles = (0, _global_styling.useEuiPaddingCSS)();
  var cssStyles = [styles.euiPopoverTitle, styles.panelPaddingSizes[panelPadding],
  // If a paddingSize is not directly provided, inherit from the EuiPopoverPanel
  paddingStyles[paddingSize || panelPadding]];
  var classes = (0, _classnames.default)('euiPopoverTitle', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), children);
};
EuiPopoverTitle.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
         * Customize the all around padding of the popover title.
         * Leave `undefined` to inherit from the `panelPaddingSize` of the containing EuiPopover
         */
  paddingSize: _propTypes.default.any
};