"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiResizableButtonWithControls = exports.EuiResizableButtonControlled = exports.EuiResizableButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _services = require("../../services");
var _context = require("./context");
var _resizable_button = require("./resizable_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isHorizontal", "indicator", "alignIndicator", "accountForScrollbars", "className"],
  _excluded2 = ["registration", "id", "disabled", "onFocus"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A generic button for indicating/facilitating resizable content,
 * usable outside of the EuiResizableContainer context
 */
var EuiResizableButton = exports.EuiResizableButton = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var isHorizontal = _ref.isHorizontal,
    _ref$indicator = _ref.indicator,
    indicator = _ref$indicator === void 0 ? 'handle' : _ref$indicator,
    _ref$alignIndicator = _ref.alignIndicator,
    alignIndicator = _ref$alignIndicator === void 0 ? 'center' : _ref$alignIndicator,
    accountForScrollbars = _ref.accountForScrollbars,
    className = _ref.className,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiResizableButton', className);
  var resizeDirection = isHorizontal ? 'horizontal' : 'vertical';
  var styles = (0, _services.useEuiMemoizedStyles)(_resizable_button.euiResizableButtonStyles);
  var cssStyles = [styles.euiResizableButton, styles[indicator], styles["".concat(indicator, "Direction")][resizeDirection], styles[resizeDirection], indicator === 'handle' && styles.alignIndicator[alignIndicator], styles.accountForScrollbars[resizeDirection][accountForScrollbars !== null && accountForScrollbars !== void 0 ? accountForScrollbars : 'none']];
  return (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiResizableButton.horizontalResizerAriaLabel', 'euiResizableButton.verticalResizerAriaLabel'],
    defaults: ['Press the left or right arrow keys to adjust panels size', 'Press the up or down arrow keys to adjust panels size']
  }, function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
      horizontalResizerAriaLabel = _ref3[0],
      verticalResizerAriaLabel = _ref3[1];
    return (0, _react2.jsx)("button", (0, _extends2.default)({
      ref: ref,
      "aria-label": isHorizontal ? horizontalResizerAriaLabel : verticalResizerAriaLabel,
      className: classes,
      css: cssStyles,
      "data-test-subj": "euiResizableButton",
      type: "button"
    }, rest));
  });
});
EuiResizableButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Defaults to displaying a resizer for vertical (y-axis) resizing.
       * Set to `true` to display a resizer for horizontal (x-axis) resizing.
       */
  isHorizontal: _propTypes.default.bool,
  /**
       * By default, EuiResizableButton will show a grab handle to indicate resizability.
       * This indicator can be optionally hidden to show a plain border instead.
       */
  indicator: _propTypes.default.oneOf(["handle", "border"]),
  /**
       * Allows customizing the alignment of grab `handle` indicators (does nothing for
       * border indicators). Defaults to `center`, but consider using `start` for extremely
       * tall content that scrolls off-screen
       */
  alignIndicator: _propTypes.default.oneOf(["center", "start", "end"]),
  /**
       * By default, EuiResizableButton will overlap into the panels before/after it.
       * This can occasionally occlude interactive elements like scrollbars. To prevent
       * this overlap, use this prop to remove the overlap for the specified side.
       */
  accountForScrollbars: _propTypes.default.oneOf(["before", "after", "both"]),
  /**
       * When disabled, the resizer button will be completely hidden
       */
  disabled: _propTypes.default.bool
};
EuiResizableButton.displayName = 'EuiResizableButton';

/**
 * Resizer button specific to controlled EuiResizableContainer usage
 */

var EuiResizableButtonControlled = exports.EuiResizableButtonControlled = function EuiResizableButtonControlled(_ref4) {
  var registration = _ref4.registration,
    id = _ref4.id,
    disabled = _ref4.disabled,
    _onFocus = _ref4.onFocus,
    rest = (0, _objectWithoutProperties2.default)(_ref4, _excluded2);
  var resizerId = (0, _services.useGeneratedHtmlId)({
    prefix: 'resizable-button',
    conditionalId: id
  });
  var _useEuiResizableConta = (0, _context.useEuiResizableContainerContext)(),
    _useEuiResizableConta2 = _useEuiResizableConta.registry,
    _useEuiResizableConta3 = _useEuiResizableConta2 === void 0 ? {
      resizers: {}
    } : _useEuiResizableConta2,
    resizers = _useEuiResizableConta3.resizers;
  var isDisabled = (0, _react.useMemo)(function () {
    var _resizers$resizerId;
    return disabled || ((_resizers$resizerId = resizers[resizerId]) === null || _resizers$resizerId === void 0 ? void 0 : _resizers$resizerId.isDisabled);
  }, [resizers, resizerId, disabled]);
  var previousRef = (0, _react.useRef)();
  var onRef = (0, _react.useCallback)(function (ref) {
    if (!registration) return;
    if (ref) {
      previousRef.current = ref;
      registration.register({
        id: resizerId,
        ref: ref,
        isFocused: false,
        isDisabled: disabled || false
      });
    } else {
      if (previousRef.current != null) {
        registration.deregister(resizerId);
        previousRef.current = undefined;
      }
    }
  }, [registration, resizerId, disabled]);
  return (0, _react2.jsx)(EuiResizableButton, (0, _extends2.default)({
    id: resizerId,
    ref: onRef,
    disabled: isDisabled,
    onClick: function onClick(e) {
      return e.currentTarget.focus();
    },
    onFocus: function onFocus() {
      return _onFocus === null || _onFocus === void 0 ? void 0 : _onFocus(resizerId);
    }
  }, rest));
};
var euiResizableButtonWithControls = exports.euiResizableButtonWithControls = function euiResizableButtonWithControls(controls) {
  return function (props) {
    return (0, _react2.jsx)(EuiResizableButtonControlled, (0, _extends2.default)({}, controls, props));
  };
};