"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiShowFor = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiShowFor = exports.EuiShowFor = function EuiShowFor(_ref) {
  var children = _ref.children,
    sizes = _ref.sizes;
  var currentBreakpoint = (0, _services.useCurrentEuiBreakpoint)();
  var isWithinBreakpointSizes = currentBreakpoint && sizes.includes(currentBreakpoint);
  if (sizes === 'all' || isWithinBreakpointSizes) {
    return (0, _react2.jsx)(_react.default.Fragment, null, children);
  }
  return null;
};
EuiShowFor.propTypes = {
  /**
     * Required otherwise nothing ever gets returned
     */
  children: _propTypes.default.node.isRequired,
  /**
     * List of all the responsive sizes to show the children for.
     * Array of #EuiBreakpointSize
     */
  sizes: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired, _propTypes.default.oneOf(["all", "none"])]).isRequired
};