"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueSelectionFilter = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _predicate = require("../../../services/predicate");
var _popover = require("../../popover");
var _filter_group = require("../../filter_group");
var _filter_group2 = require("../../filter_group/filter_group.styles");
var _selectable = require("../../selectable");
var _i18n = require("../../i18n");
var _query4 = require("../query");
var _ast = require("../query/ast");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var defaults = {
  config: {
    multiSelect: true,
    filterWith: 'prefix',
    searchThreshold: 10,
    autoSortOptions: true
  }
};
var FieldValueSelectionFilter = exports.FieldValueSelectionFilter = /*#__PURE__*/function (_Component) {
  function FieldValueSelectionFilter(props) {
    var _this;
    (0, _classCallCheck2.default)(this, FieldValueSelectionFilter);
    _this = _callSuper(this, FieldValueSelectionFilter, [props]);
    (0, _defineProperty2.default)(_this, "selectableClassRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)(_this, "cacheTimeout", void 0);
    (0, _defineProperty2.default)(_this, "loadOptions", /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
      var loadedOptions, _this$props$config, options, cache, _this$state$cachedOpt, items, _this$props, query, config;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _this.setState({
              options: null,
              error: null
            });
            _this$props$config = _this.props.config, options = _this$props$config.options, cache = _this$props$config.cache;
            _context.prev = 2;
            if (!(0, _predicate.isArray)(options)) {
              _context.next = 7;
              break;
            }
            // Synchronous options, already loaded
            loadedOptions = options;
            _context.next = 16;
            break;
          case 7:
            if (!((_this$state$cachedOpt = _this.state.cachedOptions) !== null && _this$state$cachedOpt !== void 0)) {
              _context.next = 11;
              break;
            }
            _context.t0 = _this$state$cachedOpt;
            _context.next = 14;
            break;
          case 11:
            _context.next = 13;
            return options();
          case 13:
            _context.t0 = _context.sent;
          case 14:
            loadedOptions = _context.t0;
            // If a cache time is set, populate the cache and schedule a cache reset
            if (cache != null && cache > 0) {
              _this.setState({
                cachedOptions: loadedOptions
              });
              _this.cacheTimeout = setTimeout(function () {
                _this.setState({
                  cachedOptions: null
                });
              }, cache);
            }
          case 16:
            _context.next = 21;
            break;
          case 18:
            _context.prev = 18;
            _context.t1 = _context["catch"](2);
            return _context.abrupt("return", _this.setState({
              options: null,
              error: 'Could not load options'
            }));
          case 21:
            items = {
              on: [],
              off: [],
              rest: []
            };
            _this$props = _this.props, query = _this$props.query, config = _this$props.config;
            if (loadedOptions) {
              loadedOptions.forEach(function (op) {
                var optionField = op.field || config.field;
                if (optionField) {
                  var clause = _this.multiSelect === 'or' ? query.getOrFieldClause(optionField, op.value) : query.getSimpleFieldClause(optionField, op.value);
                  var checked = _this.resolveChecked(clause);
                  if (!checked) {
                    items.rest.push(op);
                  } else if (checked === 'on') {
                    items.on.push(op);
                  } else {
                    items.off.push(op);
                  }
                }
                return;
              });
            }
            _this.setState({
              error: null,
              activeItemsCount: items.on.length,
              options: {
                unsorted: loadedOptions,
                sorted: [].concat((0, _toConsumableArray2.default)(items.on), (0, _toConsumableArray2.default)(items.off), (0, _toConsumableArray2.default)(items.rest))
              }
            }, _this.scrollToAutoSortedOption);
          case 25:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[2, 18]]);
    })));
    (0, _defineProperty2.default)(_this, "scrollToAutoSortedOption", function () {
      if (!_this.autoSortOptions) return;
      var _this$state = _this.state,
        lastCheckedValue = _this$state.lastCheckedValue,
        options = _this$state.options;
      if (lastCheckedValue) {
        var sortedIndex = options.sorted.findIndex(function (option) {
          return option.value === lastCheckedValue;
        });
        if (sortedIndex >= 0) {
          var _this$selectableClass;
          // EuiSelectable should automatically handle scrolling its list to the new index
          (_this$selectableClass = _this.selectableClassRef.current) === null || _this$selectableClass === void 0 || _this$selectableClass.setState({
            activeOptionIndex: sortedIndex
          });
        }
        _this.setState({
          lastCheckedValue: undefined
        });
      }
    });
    var _options = props.config.options;
    var preloadedOptions = (0, _predicate.isArray)(_options) ? {
      unsorted: _options,
      sorted: _options
    } : null;
    _this.state = {
      popoverOpen: false,
      error: null,
      options: preloadedOptions,
      activeItemsCount: 0
    };
    return _this;
  }
  (0, _inherits2.default)(FieldValueSelectionFilter, _Component);
  return (0, _createClass2.default)(FieldValueSelectionFilter, [{
    key: "closePopover",
    value: function closePopover() {
      this.setState({
        popoverOpen: false
      });
    }
  }, {
    key: "onButtonClick",
    value: function onButtonClick() {
      var _this2 = this;
      this.setState(function (prevState) {
        if (!prevState.popoverOpen) {
          // loading options updates the state, so we'll do that in the animation frame
          window.requestAnimationFrame(function () {
            _this2.loadOptions();
          });
        }
        return {
          options: null,
          error: null,
          popoverOpen: !prevState.popoverOpen
        };
      });
    }
  }, {
    key: "resolveOptionName",
    value: function resolveOptionName(option) {
      return option.name || option.value.toString();
    }
  }, {
    key: "onOptionClick",
    value: function onOptionClick(field, value, checked) {
      var _this$props$config2 = this.props.config,
        autoClose = _this$props$config2.autoClose,
        _this$props$config2$o = _this$props$config2.operator,
        operator = _this$props$config2$o === void 0 ? _ast.Operator.EQ : _this$props$config2$o;
      if (checked && this.autoSortOptions) {
        this.setState({
          lastCheckedValue: value
        });
      }

      // If the consumer explicitly sets `autoClose`, always defer to that.
      // Otherwise, default to auto-closing for single selections and leaving the
      // popover open for multi-select (so users can continue selecting options)
      var shouldClosePopover = autoClose !== null && autoClose !== void 0 ? autoClose : !this.multiSelect;
      if (shouldClosePopover) {
        this.closePopover();
      }
      if (!this.multiSelect) {
        var _query = checked ? this.props.query.removeSimpleFieldClauses(field).addSimpleFieldValue(field, value, true, operator) : this.props.query.removeSimpleFieldClauses(field);
        this.props.onChange(_query);
      } else if (this.multiSelect === 'or') {
        var _query2 = checked ? this.props.query.addOrFieldValue(field, value, true, operator) : this.props.query.removeOrFieldValue(field, value);
        this.props.onChange(_query2);
      } else {
        var _query3 = checked ? this.props.query.addSimpleFieldValue(field, value, true, operator) : this.props.query.removeSimpleFieldValue(field, value);
        this.props.onChange(_query3);
      }
    }
  }, {
    key: "autoSortOptions",
    get: function get() {
      var _this$props$config$au;
      return (_this$props$config$au = this.props.config.autoSortOptions) !== null && _this$props$config$au !== void 0 ? _this$props$config$au : defaults.config.autoSortOptions;
    }
  }, {
    key: "multiSelect",
    get: function get() {
      var _this$props$config$mu;
      return (_this$props$config$mu = this.props.config.multiSelect) !== null && _this$props$config$mu !== void 0 ? _this$props$config$mu : defaults.config.multiSelect;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.query.text.length) this.loadOptions();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.query !== prevProps.query) this.loadOptions();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      clearTimeout(this.cacheTimeout);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state$options,
        _this$state$options2,
        _this3 = this;
      var _this$props2 = this.props,
        query = _this$props2.query,
        config = _this$props2.config;
      var options = this.autoSortOptions ? (_this$state$options = this.state.options) === null || _this$state$options === void 0 ? void 0 : _this$state$options.sorted : (_this$state$options2 = this.state.options) === null || _this$state$options2 === void 0 ? void 0 : _this$state$options2.unsorted;
      var activeTop = this.isActiveField(config.field);
      var activeItem = options ? options.some(function (item) {
        return _this3.isActiveField(item.field);
      }) : false;
      var activeItemsCount = this.state.activeItemsCount;
      var active = (activeTop || activeItem) && activeItemsCount > 0;
      var button = (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiFieldValueSelectionFilter.buttonLabelHint",
        default: "Selection"
      }, function (buttonLabelHint) {
        var ariaLabel = "".concat(config.name, " ").concat(buttonLabelHint);
        return (0, _react2.jsx)(_filter_group.EuiFilterButton, {
          iconType: "arrowDown",
          iconSide: "right",
          hasActiveFilters: active,
          numActiveFilters: active ? activeItemsCount : undefined,
          grow: true,
          "aria-label": ariaLabel,
          onClick: _this3.onButtonClick.bind(_this3)
        }, config.name);
      });
      var items = options ? options.map(function (option) {
        var _option$view;
        var optionField = option.field || config.field;
        if (optionField == null) {
          throw new Error('option.field or field should be provided in <FieldValueSelectionFilter/>');
        }
        var clause = _this3.multiSelect === 'or' ? query.getOrFieldClause(optionField, option.value) : query.getSimpleFieldClause(optionField, option.value);
        var label = _this3.resolveOptionName(option);
        var checked = _this3.resolveChecked(clause);
        return {
          label: label,
          checked: checked,
          data: {
            view: (_option$view = option.view) !== null && _option$view !== void 0 ? _option$view : label,
            value: option.value,
            optionField: optionField
          }
        };
      }) : [];
      var threshold = config.searchThreshold || defaults.config.searchThreshold;
      var isOverSearchThreshold = options && options.length >= threshold;
      var searchProps = {
        searchable: false
      };
      if (isOverSearchThreshold) {
        searchProps = {
          searchable: true,
          searchProps: {
            compressed: true,
            disabled: this.state.error != null
          }
        };
      }
      return (0, _react2.jsx)(_services.RenderWithEuiTheme, null, function (euiThemeContext) {
        return (0, _react2.jsx)(_popover.EuiPopover, {
          button: button,
          isOpen: _this3.state.popoverOpen,
          closePopover: _this3.closePopover.bind(_this3),
          panelPaddingSize: "none",
          anchorPosition: "downCenter",
          panelProps: {
            css: (0, _filter_group2.euiFilterGroupStyles)(euiThemeContext).euiFilterGroup__popoverPanel
          }
        }, (0, _react2.jsx)(_selectable.EuiSelectable, (0, _extends2.default)({
          ref: _this3.selectableClassRef,
          singleSelection: !_this3.multiSelect,
          "aria-label": config.name,
          options: items,
          renderOption: function renderOption(option) {
            return option.view;
          },
          isLoading: (0, _predicate.isNil)(options),
          loadingMessage: config.loadingMessage,
          emptyMessage: config.noOptionsMessage,
          errorMessage: _this3.state.error,
          noMatchesMessage: config.noOptionsMessage,
          listProps: {
            isVirtualized: isOverSearchThreshold || false,
            autoFocus: true
          },
          onChange: function onChange(options, event, changedOption) {
            if (changedOption.data) {
              _this3.onOptionClick(changedOption.data.optionField, changedOption.data.value, changedOption.checked);
            }
          }
        }, searchProps), function (list, search) {
          return (0, _react2.jsx)(_react.default.Fragment, null, isOverSearchThreshold && (0, _react2.jsx)(_popover.EuiPopoverTitle, {
            paddingSize: "s"
          }, search), list);
        }));
      });
    }
  }, {
    key: "resolveChecked",
    value: function resolveChecked(clause) {
      if (clause) {
        return _query4.Query.isMust(clause) ? 'on' : 'off';
      }
    }
  }, {
    key: "isActiveField",
    value: function isActiveField(field) {
      if (typeof field !== 'string') {
        return false;
      }
      var query = this.props.query;
      if (this.multiSelect === 'or') {
        return query.hasOrFieldClause(field);
      }
      return query.hasSimpleFieldClause(field);
    }
  }]);
}(_react.Component);
FieldValueSelectionFilter.propTypes = {
  index: _propTypes.default.number.isRequired,
  config: _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_selection"]).isRequired,
    field: _propTypes.default.string,
    name: _propTypes.default.string.isRequired,
    /**
       * See #FieldValueOptionType
       */
    options: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
      field: _propTypes.default.string,
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
        type: _propTypes.default.oneOf(["date"]).isRequired,
        raw: _propTypes.default.any.isRequired,
        granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
          es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
          js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
          isSame: _propTypes.default.func.isRequired,
          start: _propTypes.default.func.isRequired,
          startOfNext: _propTypes.default.func.isRequired,
          iso8601: _propTypes.default.func.isRequired
        }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
        text: _propTypes.default.string.isRequired,
        resolve: _propTypes.default.func.isRequired
      }).isRequired]).isRequired,
      name: _propTypes.default.string,
      view: _propTypes.default.node
    }).isRequired).isRequired, _propTypes.default.func.isRequired]).isRequired,
    filterWith: _propTypes.default.oneOfType([_propTypes.default.oneOf(["prefix", "includes"]), _propTypes.default.func.isRequired]),
    cache: _propTypes.default.number,
    multiSelect: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["and", "or"])]),
    loadingMessage: _propTypes.default.string,
    noOptionsMessage: _propTypes.default.string,
    searchThreshold: _propTypes.default.number,
    available: _propTypes.default.func,
    autoClose: _propTypes.default.bool,
    operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"]),
    autoSortOptions: _propTypes.default.bool
  }).isRequired,
  query: _propTypes.default.any.isRequired,
  onChange: _propTypes.default.func.isRequired
};