"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _basic_table = require("../basic_table");
var _flex = require("../flex");
var _health = require("../health");
var _spacer = require("../spacer");
var _search_bar = require("./search_bar");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var tags = [{
  name: 'marketing',
  color: 'danger'
}, {
  name: 'finance',
  color: 'success'
}, {
  name: 'eng',
  color: 'success'
}, {
  name: 'sales',
  color: 'warning'
}, {
  name: 'ga',
  color: 'success'
}];
var tagsMap = tags.map(function (tag) {
  return {
    value: tag.name,
    view: (0, _react2.jsx)(_health.EuiHealth, {
      color: tag.color
    }, tag.name)
  };
});
var items = [{
  type: 'Dashboard',
  id: 1,
  status: 'Open',
  tag: ['finance', 'sales', 'marketing'],
  owner: 'Dewey'
}, {
  type: 'Visualization',
  id: 2,
  status: 'Open',
  tag: ['finance'],
  owner: 'Wanda'
}, {
  type: 'Dashboard',
  id: 3,
  status: 'Closed',
  tag: ['eng'],
  owner: 'Carrie'
}, {
  type: 'Watch',
  id: 4,
  status: 'Open',
  tag: ['sales', 'ga'],
  owner: 'Dewey'
}, {
  type: 'Dashboard',
  id: 5,
  status: 'Closed',
  tag: ['finance'],
  owner: 'Carrie'
}];
var SearchBar = exports.SearchBar = function SearchBar() {
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    query = _useState2[0],
    setQuery = _useState2[1];
  var renderSearch = function renderSearch() {
    var filters = [{
      type: 'field_value_toggle_group',
      field: 'status',
      items: [{
        value: 'open',
        name: 'Open'
      }, {
        value: 'closed',
        name: 'Closed'
      }]
    }, {
      type: 'field_value_selection',
      field: 'tag',
      name: 'Tag',
      multiSelect: 'or',
      options: tagsMap
    }];
    var schema = {
      strict: true,
      fields: {
        type: {
          type: 'string'
        },
        status: {
          type: 'string'
        },
        created: {
          type: 'date'
        },
        owner: {
          type: 'string'
        },
        tag: {
          type: 'string'
        }
      }
    };
    return (0, _react2.jsx)(_search_bar.EuiSearchBar, {
      query: query,
      box: {
        placeholder: 'type:visualization',
        schema: schema
      },
      filters: filters,
      onChange: function onChange(_ref) {
        var query = _ref.query;
        if (query) setQuery(query);
      }
    });
  };
  var renderTable = function renderTable() {
    var columns = [{
      name: 'Type',
      field: 'type'
    }, {
      name: 'Owner',
      field: 'owner'
    }, {
      name: 'Open',
      field: 'status'
    }, {
      name: 'Tags',
      field: 'tag'
    }];
    var queriedItems = _search_bar.EuiSearchBar.Query.execute(query, items, {
      defaultFields: ['owner', 'tag', 'type']
    });
    return (0, _react2.jsx)(_basic_table.EuiBasicTable, {
      items: queriedItems,
      columns: columns
    });
  };
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    alignItems: "center"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, renderSearch())), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "l"
  }), (0, _react2.jsx)(_flex.EuiFlexGroup, null, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: 6
  }, renderTable())));
};
describe('EuiSearchBar', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(SearchBar, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after a full-text search', function () {
      cy.get('input[type="search"]').focus();
      cy.get('input[type="search"]').type('watch');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 1);
      cy.checkAxe();
      cy.realPress('Tab');
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
    it('has zero violations after filtering on Open items', function () {
      cy.get('button.euiButtonEmpty').first().focus();
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 3);
      cy.checkAxe();
      cy.realPress(['Shift', 'Tab']);
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
    it('has zero violations after filtering by Tags', function () {
      cy.get('button.euiButtonEmpty').last().focus();
      cy.realPress('Enter');
      cy.realPress('ArrowDown');
      cy.realPress('Enter');
      cy.realPress('Escape');
      cy.get('button.euiButtonEmpty').last().should('have.focus');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 3);
      cy.checkAxe();
      cy.repeatRealPress(['Shift', 'Tab'], 3);
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
  });
});