"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _popover = require("../popover");
var _selectable = require("./selectable");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var options = [{
  label: 'Titan',
  'data-test-subj': 'titanOption'
}, {
  label: 'Enceladus'
}, {
  label: "Pandora is one of Saturn's moons, named for a Titaness of Greek mythology"
}];
var excludedOptions = [{
  label: 'Titan',
  'data-test-subj': 'titanOption',
  checked: 'on'
}, {
  label: 'Enceladus',
  checked: 'off'
}, {
  label: "Pandora is one of Saturn's moons, named for a Titaness of Greek mythology",
  checked: 'mixed'
}];
describe('EuiSelectable', function () {
  describe('with a `searchable` configuration', function () {
    it('has no accessibility errors', function () {
      var onChange = cy.stub();
      cy.realMount((0, _react2.jsx)(_selectable.EuiSelectable, {
        options: options,
        onChange: onChange,
        searchable: true
      }, function (list, search) {
        return (0, _react2.jsx)(_react.default.Fragment, null, search, list);
      }));
      cy.checkAxe();
    });
  });
  describe('without a `searchable` configuration', function () {
    it('has no accessibility errors', function () {
      var onChange = cy.stub();
      cy.realMount((0, _react2.jsx)(_selectable.EuiSelectable, {
        "aria-label": "No search box",
        options: options,
        onChange: onChange
      }, function (list) {
        return (0, _react2.jsx)(_react.default.Fragment, null, list);
      }));
      cy.checkAxe();
    });
  });
  describe('with excluded and mixed options configuration', function () {
    it('has no accessibility errors', function () {
      var onChange = cy.stub();
      cy.realMount((0, _react2.jsx)(_selectable.EuiSelectable, {
        "aria-label": "Excluded and mixed options",
        options: excludedOptions,
        onChange: onChange
      }, function (list) {
        return (0, _react2.jsx)(_react.default.Fragment, null, list);
      }));
      cy.checkAxe();
    });
  });
  describe('nested in `EuiPopover` component', function () {
    var EuiSelectableNested = function EuiSelectableNested() {
      var _useState = (0, _react.useState)(false),
        _useState2 = (0, _slicedToArray2.default)(_useState, 2),
        isPopoverOpen = _useState2[0],
        setIsPopoverOpen = _useState2[1];
      var onChange = function onChange() {};
      var onClosePopover = function onClosePopover() {};
      var onButtonClick = function onButtonClick() {
        setIsPopoverOpen(!isPopoverOpen);
      };
      var button = (0, _react2.jsx)(_button.EuiButton, {
        iconType: "arrowDown",
        iconSide: "right",
        onClick: onButtonClick
      }, "Show popover");
      return (0, _react2.jsx)(_popover.EuiPopover, {
        id: "data-cy-popover-1",
        panelPaddingSize: "s",
        button: button,
        isOpen: isPopoverOpen,
        closePopover: onClosePopover
      }, (0, _react2.jsx)(_selectable.EuiSelectable, {
        "aria-label": "With popover",
        options: options,
        onChange: onChange,
        searchable: true
      }, function (list, search) {
        return (0, _react2.jsx)(_react.default.Fragment, null, search, list);
      }));
    };
    it('has no accessibility errors', function () {
      cy.realMount((0, _react2.jsx)(EuiSelectableNested, null));
      cy.get('button').realClick();
      cy.get('li[role=option]').first(); // Make sure the EuiSelectable is rendered before a11y check
      cy.checkAxe();
    });
  });
});