"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSelectableTemplateSitewideRenderOptions = exports.euiSelectableTemplateSitewideFormatOptions = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _icon = require("../../icon");
var _avatar = require("../../avatar");
var _highlight = require("../../highlight");
var _selectable_template_sitewide = require("./selectable_template_sitewide.styles");
var _react2 = require("@emotion/react");
var _excluded = ["text", "highlightSearchString", "className"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /**
 * The generic extension allows consumers to keep their data objects
 * intact without needing to do key lookups when using `renderOption`
 */
var euiSelectableTemplateSitewideFormatOptions = exports.euiSelectableTemplateSitewideFormatOptions = function euiSelectableTemplateSitewideFormatOptions(options, styles) {
  return options.map(function (item) {
    var title = item.label;
    if (item.meta && item.meta.length) {
      title += " \u2022".concat(renderOptionMeta({
        meta: item.meta,
        stringsOnly: true,
        styles: styles
      }));
    }
    return _objectSpread(_objectSpread({
      key: item.label,
      title: title
    }, item), {}, {
      css: [styles.euiSelectableTemplateSitewide__listItem, item.css],
      className: (0, _classnames.default)('euiSelectableTemplateSitewide__listItem', item.className),
      prepend: item.icon ? (0, _react2.jsx)(_icon.EuiIcon, (0, _extends2.default)({
        color: "subdued",
        size: "l"
      }, item.icon)) : item.prepend,
      append: item.avatar ? (0, _react2.jsx)(_avatar.EuiAvatar, (0, _extends2.default)({
        type: "space",
        size: "s"
      }, item.avatar)) : item.append
    });
  });
};
var euiSelectableTemplateSitewideRenderOptions = exports.euiSelectableTemplateSitewideRenderOptions = function euiSelectableTemplateSitewideRenderOptions(option, searchValue) {
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_highlight.EuiHighlight, {
    className: "euiSelectableTemplateSitewide__listItemTitle",
    search: searchValue
  }, option.label), (0, _react2.jsx)(_services.RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
    var styles = stylesMemoizer(_selectable_template_sitewide.euiSelectableTemplateSitewideStyles);
    return renderOptionMeta({
      meta: option.meta,
      styles: styles,
      searchValue: searchValue
    });
  }));
};
var renderOptionMeta = function renderOptionMeta(_ref) {
  var meta = _ref.meta,
    styles = _ref.styles,
    _ref$searchValue = _ref.searchValue,
    searchValue = _ref$searchValue === void 0 ? '' : _ref$searchValue,
    _ref$stringsOnly = _ref.stringsOnly,
    stringsOnly = _ref$stringsOnly === void 0 ? false : _ref$stringsOnly;
  if (!meta || meta.length < 1) return;
  var metas = meta.map(function (meta) {
    var text = meta.text,
      highlightSearchString = meta.highlightSearchString,
      className = meta.className,
      rest = (0, _objectWithoutProperties2.default)(meta, _excluded);
    if (stringsOnly) {
      return " ".concat(text);
    }

    // Start with the base and custom classes
    var metaClasses = (0, _classnames.default)('euiSelectableTemplateSitewide__optionMeta', className);

    // If they provided a type, create the class and append
    if (meta.type) {
      metaClasses = (0, _classnames.default)(["euiSelectableTemplateSitewide__optionMeta--".concat(meta.type)], metaClasses);
    }
    var hasMetaTypeStyles = function hasMetaTypeStyles(metaType) {
      return metaType in styles.metaTypes;
    };
    var cssStyles = [styles.euiSelectableTemplateSitewide__optionMeta].concat((0, _toConsumableArray2.default)(meta.type && hasMetaTypeStyles(meta.type) ? [styles.metaTypes.fontWeight, styles.metaTypes[meta.type]] : []));
    return (0, _react2.jsx)(_highlight.EuiHighlight, (0, _extends2.default)({
      search: highlightSearchString ? searchValue : '',
      css: cssStyles,
      className: metaClasses,
      key: text
    }, rest), text);
  });
  return stringsOnly ? metas : (0, _react2.jsx)("span", {
    css: styles.euiSelectableTemplateSitewide__optionMetasList,
    className: "euiSelectableTemplateSitewide__optionMetasList"
  }, metas);
};